/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.domain.helpers;

import cn.gtmap.gtc.model.domain.entity.EntityMeta;
import cn.gtmap.gtc.model.domain.entity.Meta;
import cn.gtmap.gtc.model.domain.helpers.EntityBuilder;
import cn.gtmap.gtc.model.domain.helpers.EntityClassLoader;
import cn.gtmap.gtc.model.domain.helpers.EntityHelper;
import cn.gtmap.gtc.model.domain.helpers.OrmAnn;
import cn.gtmap.gtc.model.domain.helpers.OrmAnns;
import cn.gtmap.gtc.model.domain.helpers.OrmName;
import cn.gtmap.gtc.model.domain.helpers.OrmType;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntityBuilder {
    private static final Logger log = LoggerFactory.getLogger(EntityBuilder.class);
    private static final boolean DEBUG = "dev".equals(System.getProperty("spring.profiles.active", null));
    private int invokeCount = 0;
    public static final String ENTITY_PACKAGE = "cn.gtmap.dynamic.entity";
    private static final String INTERNAL_ENTITY_PACKAGE = "cn.gtmap.dynamic.entity".replace('.', '/');
    private EntityMeta entityMeta = null;
    private EntityClassLoader entityClassLoader = null;

    public EntityClassLoader getEntityClassLoader() {
        if (this.entityClassLoader == null) {
            this.entityClassLoader = new EntityClassLoader(this.getClass().getClassLoader());
        }
        return this.entityClassLoader;
    }

    public EntityBuilder withEntityMeta(EntityMeta entityMeta) {
        this.entityMeta = entityMeta;
        return this;
    }

    public EntityBuilder withEntityClassLoader(EntityClassLoader entityClassLoader) {
        this.entityClassLoader = entityClassLoader;
        return this;
    }

    public Class<?> build() {
        Class cls = null;
        byte[] bytes = this.buildBytes();
        try {
            cls = this.getEntityClassLoader().findClass(bytes);
            log.debug(String.format("class is%s null", cls == null ? "n't" : ""));
        }
        catch (LinkageError ex) {
            log.error(ex.getMessage());
        }
        if (cls == null) {
            throw new ClassFormatError("too few class loaders");
        }
        return cls;
    }

    public byte[] buildBytes() {
        if (this.entityMeta == null) {
            return new byte[0];
        }
        this.getEntityClassLoader();
        Info entityInfo = this.getInfoFromMeta((Meta)this.entityMeta);
        Map annotationMap = entityInfo.annotationMap;
        if (!annotationMap.containsKey(Entity.class) && !annotationMap.containsKey(Embeddable.class)) {
            annotationMap.put(Entity.class, new HashMap());
        }
        List entityFieldsInfo = this.entityMeta.getFields().stream().map(arg_0 -> this.getInfoFromMeta(arg_0)).collect(Collectors.toList());
        ClassNode classNode = this.createClassNode(entityInfo, entityFieldsInfo);
        ClassWriter classWriter = new ClassWriter(0);
        classNode.accept((ClassVisitor)classWriter);
        byte[] bytes = classWriter.toByteArray();
        if (DEBUG) {
            String filePath = String.format("%s../../src/test/resources/debug/temp-%d.class", this.getClass().getResource("/").getPath(), this.invokeCount++);
            try (FileOutputStream outputStream = new FileOutputStream(filePath);){
                ((OutputStream)outputStream).write(bytes);
            }
            catch (Exception ex) {
                log.error(ex.getMessage());
            }
        }
        return bytes;
    }

    public Class<?> findByClassLoaders(String className) throws ClassNotFoundException {
        Class<?> cls = null;
        try {
            cls = Class.forName(className, true, (ClassLoader)this.getEntityClassLoader());
        }
        catch (ClassNotFoundException ex) {
            log.error(ex.getMessage());
            throw ex;
        }
        return cls;
    }

    private static boolean isCollection(Type type) {
        try {
            Class<?> cls = Class.forName(type.getClassName());
            return Collection.class.isAssignableFrom(cls);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private static Type stringToType(String typeName) {
        Class cls;
        switch (typeName.toLowerCase()) {
            case "int": 
            case "integer": {
                cls = Integer.class;
                break;
            }
            case "long": {
                cls = Long.class;
                break;
            }
            case "short": {
                cls = Short.class;
                break;
            }
            case "byte": {
                cls = Byte.class;
                break;
            }
            case "big_integer": 
            case "big_int": {
                cls = BigInteger.class;
                break;
            }
            case "big_decimal": 
            case "decimal": 
            case "number": {
                cls = BigDecimal.class;
                break;
            }
            case "double": 
            case "float": {
                cls = Double.class;
                break;
            }
            case "str": 
            case "string": 
            case "char": 
            case "character": {
                cls = String.class;
                break;
            }
            case "bool": 
            case "boolean": {
                cls = Boolean.class;
                break;
            }
            case "date": 
            case "time": 
            case "timestamp": {
                cls = Date.class;
                break;
            }
            default: {
                return Type.getType((String)String.format("L%s/%s;", INTERNAL_ENTITY_PACKAGE, typeName));
            }
        }
        return Type.getType(cls);
    }

    private ClassNode createClassNode(Info classInfo, List<Info> fieldsInfo) {
        ClassNode classNode = new ClassNode(393216);
        classNode.version = 52;
        classNode.name = INTERNAL_ENTITY_PACKAGE + '/' + classInfo.name;
        classNode.access = 1;
        classNode.superName = Type.getInternalName(Object.class);
        classNode.visibleAnnotations = this.createAnnotationNodes(classInfo.annotationMap);
        List methodNodes = classNode.methods;
        List collFieldsInfo = fieldsInfo.stream().filter(fieldInfo -> EntityBuilder.isCollection((Type)fieldInfo.type)).collect(Collectors.toList());
        methodNodes.add(this.createDefaultConstructorNode(classNode.superName, classNode, collFieldsInfo));
        List fieldNodes = classNode.fields;
        fieldsInfo.forEach(fieldInfo -> {
            fieldNodes.add(this.createFieldNode(fieldInfo));
            methodNodes.add(this.createGetterNode(classNode, fieldInfo));
            methodNodes.add(this.createSetterNode(classNode, fieldInfo));
        });
        classNode.visitEnd();
        return classNode;
    }

    private FieldNode createFieldNode(Info fieldInfo) {
        FieldNode fieldNode = new FieldNode(2, fieldInfo.name, fieldInfo.type.getDescriptor(), this.typesToGenericDescriptor(fieldInfo.type, fieldInfo.elementType), null);
        fieldNode.visibleAnnotations = this.createAnnotationNodes(fieldInfo.annotationMap);
        return fieldNode;
    }

    private List<AnnotationNode> createAnnotationNodes(Map<Class<?>, Map<String, Object>> annotationMap) {
        if (annotationMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationNode> annotationNodes = new ArrayList<AnnotationNode>();
        for (Map.Entry<Class<?>, Map<String, Object>> annInfo : annotationMap.entrySet()) {
            Class<?> annClass = annInfo.getKey();
            AnnotationNode annotationNode = new AnnotationNode(Type.getDescriptor(annClass));
            for (Map.Entry<String, Object> annParam : annInfo.getValue().entrySet()) {
                String paramKey = annParam.getKey();
                Object paramValue = annParam.getValue();
                if (paramValue.getClass().isArray()) {
                    AnnotationVisitor annVisitor = annotationNode.visitArray(paramKey);
                    for (Object o : (Object[])paramValue) {
                        this.visitAnn(annVisitor, null, o);
                    }
                    annVisitor.visitEnd();
                    continue;
                }
                this.visitAnn((AnnotationVisitor)annotationNode, paramKey, paramValue);
            }
            annotationNode.visitEnd();
            annotationNodes.add(annotationNode);
        }
        return annotationNodes;
    }

    private void visitAnn(AnnotationVisitor annotationVisitor, String paramKey, Object paramValue) {
        if (paramValue instanceof Enum) {
            Enum paramValueAsEnum = (Enum)paramValue;
            annotationVisitor.visitEnum(paramKey, Type.getDescriptor(paramValue.getClass()), paramValueAsEnum.name());
        } else if (paramValue instanceof Class) {
            annotationVisitor.visit(paramKey, (Object)Type.getType((Class)((Class)paramValue)));
        } else {
            annotationVisitor.visit(paramKey, paramValue);
        }
    }

    private MethodNode createDefaultConstructorNode(String superInternalName, ClassNode classNode, List<Info> collFieldsInfo) {
        String constructorName = "<init>";
        String voidMethodDesc = "()V";
        MethodNode methodNode = new MethodNode();
        methodNode.access = 1;
        methodNode.name = "<init>";
        methodNode.signature = "()V";
        methodNode.desc = "()V";
        methodNode.exceptions = new ArrayList();
        InsnList insnList = methodNode.instructions;
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList.add((AbstractInsnNode)new MethodInsnNode(183, superInternalName, "<init>", "()V", false));
        collFieldsInfo.forEach(fieldInfo -> {
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            Type implType = this.implTypeFromInterfaceType(fieldInfo.type);
            String implClassName = implType.getInternalName();
            insnList.add((AbstractInsnNode)new TypeInsnNode(187, implClassName));
            insnList.add((AbstractInsnNode)new InsnNode(89));
            insnList.add((AbstractInsnNode)new MethodInsnNode(183, implClassName, "<init>", "()V", false));
            insnList.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, fieldInfo.name, fieldInfo.type.getDescriptor()));
        });
        insnList.add((AbstractInsnNode)new InsnNode(177));
        methodNode.maxLocals = 6;
        methodNode.maxStack = 6;
        return methodNode;
    }

    private Type implTypeFromInterfaceType(Type interfaceType) {
        String interfaceDesc = interfaceType.getDescriptor();
        Class implClass = interfaceDesc.equals(Type.getDescriptor(Set.class)) ? HashSet.class : (interfaceDesc.equals(Type.getDescriptor(Collection.class)) || interfaceDesc.equals(Type.getDescriptor(List.class)) ? ArrayList.class : (interfaceDesc.equals(Type.getDescriptor(Map.class)) ? HashMap.class : ArrayList.class));
        return Type.getType(implClass);
    }

    private MethodNode createGetterNode(ClassNode classNode, Info fieldInfo) {
        String fieldName = fieldInfo.name;
        String fieldDesc = fieldInfo.type.getDescriptor();
        MethodNode methodNode = new MethodNode(1, EntityHelper.getterNameFromFieldName((String)fieldName), "()" + fieldDesc, "()" + this.typesToGenericDescriptor(fieldInfo.type, fieldInfo.elementType), new String[0]);
        InsnList insnList = methodNode.instructions;
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, fieldName, fieldDesc));
        insnList.add((AbstractInsnNode)new InsnNode(fieldInfo.type.getOpcode(172)));
        methodNode.maxStack = methodNode.maxLocals = fieldInfo.type.getSize();
        return methodNode;
    }

    private MethodNode createSetterNode(ClassNode classNode, Info fieldInfo) {
        String fieldName = fieldInfo.name;
        String fieldDesc = fieldInfo.type.getDescriptor();
        MethodNode methodNode = new MethodNode(1, EntityHelper.setterNameFromFieldName((String)fieldName), String.format("(%s)V", fieldDesc), String.format("(%s)V", this.typesToGenericDescriptor(fieldInfo.type, fieldInfo.elementType)), new String[0]);
        InsnList insnList = methodNode.instructions;
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList.add((AbstractInsnNode)new VarInsnNode(fieldInfo.type.getOpcode(21), 1));
        insnList.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, fieldName, fieldDesc));
        insnList.add((AbstractInsnNode)new InsnNode(177));
        methodNode.maxLocals = methodNode.maxStack = fieldInfo.type.getSize() + 1;
        return methodNode;
    }

    private Info getInfoFromMeta(Meta meta) {
        Info info = new Info(this);
        Class<?> metaClass = meta.getClass();
        HashMap annParamOnlyFields = new HashMap();
        HashMap annMap = new HashMap();
        for (Field field : metaClass.getDeclaredFields()) {
            try {
                this.fillName(info, meta, field);
                this.fillType(info, meta, field);
                OrmAnns ormAnns = field.getAnnotation(OrmAnns.class);
                if (ormAnns == null) {
                    OrmAnn ormAnn = field.getAnnotation(OrmAnn.class);
                    if (ormAnn == null) continue;
                    this.fillAnnotationMapFromFieldMetaForAnn(info, meta, field, ormAnn, annMap, annParamOnlyFields);
                    continue;
                }
                for (OrmAnn ormAnn : ormAnns.value()) {
                    this.fillAnnotationMapFromFieldMetaForAnn(info, meta, field, ormAnn, annMap, annParamOnlyFields);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException ex) {
                log.error(ex.getMessage());
            }
        }
        for (Map.Entry entry : annParamOnlyFields.entrySet()) {
            try {
                Class annClass;
                List annClasses = annMap.getOrDefault(entry.getKey(), Collections.emptyList());
                if (annClasses.size() != 1 || !info.annotationMap.containsKey(annClass = (Class)annClasses.get(0))) continue;
                for (Field field : (List)entry.getValue()) {
                    this.fillAnnotationMapFromFieldMetaForAnnParam(info, meta, field, annClass);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException ex) {
                log.error(ex.getMessage());
            }
        }
        info.validate();
        return info;
    }

    private void fillName(Info info, Meta meta, Field field) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        OrmName ormName = field.getAnnotation(OrmName.class);
        if (ormName == null) {
            return;
        }
        info.name = (String)EntityHelper.readFieldOf((Object)meta, (String)field.getName());
    }

    private void fillType(Info info, Meta meta, Field field) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        OrmType ormType = field.getAnnotation(OrmType.class);
        if (ormType == null) {
            return;
        }
        String filedValue = (String)EntityHelper.readFieldOf((Object)meta, (String)field.getName());
        info.type = EntityBuilder.stringToType((String)filedValue);
    }

    private void fillAnnotationMapFromFieldMetaForAnn(Info info, Meta meta, Field field, OrmAnn ormAnn, Map<String, List<Class<?>>> annMap, Map<String, List<Field>> annParamOnlyFields) throws IllegalAccessException, NoSuchFieldException, NoSuchMethodException, InvocationTargetException {
        String fieldName = field.getName();
        Object[] fieldValue = EntityHelper.readFieldOf((Object)meta, (String)fieldName);
        String dependent = ormAnn.dependOn();
        if (dependent.length() == 0) {
            String annParamName;
            if (!annMap.containsKey(fieldName)) {
                annMap.put(fieldName, new ArrayList());
            }
            Class annClass = ormAnn.annotation();
            if (ormAnn.fieldValAsAnn()) {
                if (fieldValue == null) {
                    return;
                }
                Class constFieldClass = ormAnn.stringAsConstantFieldOf();
                if (constFieldClass.equals(Void.TYPE)) {
                    return;
                }
                annClass = (Class)constFieldClass.getField((String)fieldValue).get(constFieldClass);
                if (!info.annotationMap.containsKey(annClass)) {
                    info.annotationMap.put(annClass, new HashMap());
                }
                annMap.get(fieldName).add(annClass);
            }
            if (annClass.equals(Void.TYPE)) {
                return;
            }
            if (ormAnn.booleanAsEnable()) {
                if (fieldValue == null || !((Boolean)fieldValue).booleanValue()) {
                    return;
                }
                if (!info.annotationMap.containsKey(annClass)) {
                    info.annotationMap.put(annClass, new HashMap());
                }
                annMap.get(fieldName).add(annClass);
            }
            if ((annParamName = ormAnn.fieldValAsAnnParam()).length() > 0) {
                if (fieldValue == null) {
                    return;
                }
                Class constFieldClass = ormAnn.stringAsConstantFieldOf();
                Object[] annParamValue = null;
                if (Collection.class.isAssignableFrom(fieldValue.getClass())) {
                    ArrayList<Object> annParamValueAsList = new ArrayList<Object>();
                    for (String s : (Collection)fieldValue) {
                        annParamValueAsList.add(constFieldClass.getField(s).get(constFieldClass));
                    }
                    annParamValue = annParamValueAsList.toArray();
                } else {
                    annParamValue = fieldValue;
                    if (!constFieldClass.equals(Void.TYPE)) {
                        annParamValue = constFieldClass.getField((String)fieldValue).get(constFieldClass);
                    }
                }
                if (annParamValue != null) {
                    if (!info.annotationMap.containsKey(annClass)) {
                        info.annotationMap.put(annClass, new HashMap());
                    }
                    ((Map)info.annotationMap.get(annClass)).put(annParamName, annParamValue);
                }
            }
        } else {
            if (!annParamOnlyFields.containsKey(dependent)) {
                annParamOnlyFields.put(dependent, new ArrayList());
            }
            annParamOnlyFields.get(dependent).add(field);
        }
    }

    private void fillAnnotationMapFromFieldMetaForAnnParam(Info info, Meta meta, Field field, Class<?> annClass) throws IllegalAccessException, NoSuchFieldException, NoSuchMethodException, InvocationTargetException {
        String fieldName = field.getName();
        OrmAnn ormAnn = field.getAnnotation(OrmAnn.class);
        String annParamName = ormAnn.fieldValAsAnnParam();
        Class constFieldClass = ormAnn.stringAsConstantFieldOf();
        Object[] annParamValue = EntityHelper.readFieldOf((Object)meta, (String)fieldName);
        if (annParamValue == null) {
            return;
        }
        if (annParamValue instanceof String) {
            String fieldValueAsString = (String)annParamValue;
            if (!constFieldClass.equals(Void.TYPE)) {
                annParamValue = constFieldClass.getField(fieldValueAsString).get(constFieldClass);
            }
        } else if (annParamValue instanceof Collection) {
            LinkedList<Object> annParamValueList = new LinkedList<Object>();
            for (Object fieldValue : (Collection)annParamValue) {
                if (!(fieldValue instanceof String)) continue;
                String fieldValueAsString = (String)fieldValue;
                if (constFieldClass.equals(Void.TYPE)) continue;
                annParamValueList.add(constFieldClass.getField(fieldValueAsString).get(constFieldClass));
            }
            annParamValue = annParamValueList.toArray();
        } else {
            return;
        }
        ((Map)info.annotationMap.get(annClass)).put(annParamName, annParamValue);
    }

    private String typesToGenericDescriptor(Type genericType, Type type) {
        if (type == null) {
            return genericType.getDescriptor();
        }
        return String.format("L%s<%s>;", genericType.getInternalName(), type.getDescriptor());
    }
}

