/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.domain.helpers;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class CascadeSorter {
    private static final String ORDER_PREFIX = "order.";
    private static final String ORDER_REGEX = "^-?\\w+$";
    private static final int DEPTH_LIMIT = 5;
    private static final int CHILD_AS_DEPTH = 1;
    private ImmutableList<ImmutablePair<String, Boolean>> defaultOrders;
    private ImmutableList<ImmutablePair<String, ImmutableList<ImmutablePair<String, Boolean>>>> rules;
    private ImmutableList<ImmutablePair<String, CascadeSorter>> children;

    public static CascadeSorter of(String defaultSortsExpr) {
        List defaultOrders = Arrays.stream(defaultSortsExpr.split(",")).map(String::trim).filter(sort -> sort.matches(ORDER_REGEX)).collect(Collectors.toList());
        return new CascadeSorter(defaultOrders);
    }

    public static CascadeSorter of(Map<String, String[]> parameterMap) {
        LinkedHashMap<String, ImmutableList> allRules = new LinkedHashMap<String, ImmutableList>();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            if (!entry.getKey().startsWith(ORDER_PREFIX)) continue;
            String key = entry.getKey().replaceFirst(ORDER_PREFIX, "");
            String[] val = entry.getValue();
            if (Strings.isNullOrEmpty((String)key) || val.length <= 0) continue;
            List bys = Arrays.stream(val).map(CascadeSorter::orderStringToPair).collect(Collectors.toList());
            allRules.put(key, ImmutableList.copyOf(bys));
        }
        return new CascadeSorter(allRules);
    }

    private static ImmutablePair<String, Boolean> orderStringToPair(String order) {
        boolean asc = !order.startsWith("-");
        return ImmutablePair.of((Object)(asc ? order : order.substring(1)), (Object)asc);
    }

    private CascadeSorter(List<String> defaultOrders) {
        this.initByDefaultOrders(defaultOrders);
    }

    private CascadeSorter(LinkedHashMap<String, ImmutableList<ImmutablePair<String, Boolean>>> ruleMap) {
        this.initByRuleMap(ruleMap);
    }

    public void cascadeSort(Object entity) {
        this.cascadeSort(entity, 1);
    }

    private void cascadeSort(Object entity, int depth) {
        if (depth >= 5) {
            return;
        }
        if (!this.rules.isEmpty()) {
            this.sortByRules(entity);
        } else if (!this.defaultOrders.isEmpty()) {
            this.sortByDefaultOrders(entity);
        } else {
            return;
        }
        this.deepSort(entity, depth);
    }

    private void initByDefaultOrders(List<String> defaultOrders) {
        List rulePairs = defaultOrders.stream().map(CascadeSorter::orderStringToPair).collect(Collectors.toList());
        this.defaultOrders = ImmutableList.copyOf(rulePairs);
        this.rules = ImmutableList.of();
        this.children = ImmutableList.of();
    }

    private void initByRuleMap(LinkedHashMap<String, ImmutableList<ImmutablePair<String, Boolean>>> ruleMap) {
        LinkedHashMap<String, ImmutableList<ImmutablePair<String, Boolean>>> ownRules = new LinkedHashMap<String, ImmutableList<ImmutablePair<String, Boolean>>>();
        LinkedHashMap childrenRules = new LinkedHashMap();
        for (Map.Entry<String, ImmutableList<ImmutablePair<String, Boolean>>> rule : ruleMap.entrySet()) {
            String ruleKey = rule.getKey();
            ImmutableList<ImmutablePair<String, Boolean>> ruleVal = rule.getValue();
            String[] keySegments = ruleKey.split("\\.");
            if (1 == keySegments.length) {
                ownRules.put(ruleKey, ruleVal);
                continue;
            }
            String fieldName = keySegments[0];
            String childKey = ruleKey.replaceFirst(fieldName + ".", "");
            if (!childrenRules.containsKey(fieldName)) {
                childrenRules.put(fieldName, new LinkedHashMap());
            }
            ((LinkedHashMap)childrenRules.get(fieldName)).put(childKey, rule.getValue());
        }
        this.rules = ImmutableList.copyOf((Collection)ownRules.entrySet().stream().map(entry -> ImmutablePair.of(entry.getKey(), entry.getValue())).collect(Collectors.toList()));
        this.children = ImmutableList.copyOf((Collection)childrenRules.entrySet().stream().map(entry -> ImmutablePair.of(entry.getKey(), (Object)new CascadeSorter((LinkedHashMap)entry.getValue()))).collect(Collectors.toList()));
        this.defaultOrders = ImmutableList.of();
    }

    private void sortByDefaultOrders(Object entity) {
        for (Field field : entity.getClass().getDeclaredFields()) {
            if (!Collection.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                Object fieldValue = field.get(entity);
                if (fieldValue == null) continue;
                this.shallowSort((List)fieldValue, (List)this.defaultOrders);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    private void sortByRules(Object entity) {
        for (ImmutablePair rule : this.rules) {
            String fieldName = (String)rule.getKey();
            try {
                Field field = entity.getClass().getDeclaredField(fieldName);
                if (!Collection.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                Object fieldValue = field.get(entity);
                if (fieldValue == null || !(fieldValue instanceof List)) continue;
                this.shallowSort((List)fieldValue, (List)rule.getValue());
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        }
    }

    private void deepSort(Object entity, int depth) {
        for (ImmutablePair child : this.children) {
            String fieldName = (String)child.getKey();
            CascadeSorter childSorter = (CascadeSorter)child.getValue();
            try {
                Field field = entity.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                Object fieldValue = field.get(entity);
                if (fieldValue == null) continue;
                if (fieldValue instanceof List) {
                    for (Object childEntity : (List)fieldValue) {
                        childSorter.cascadeSort(childEntity, depth + 1);
                    }
                    continue;
                }
                childSorter.cascadeSort(fieldValue, depth + 1);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        }
    }

    private void shallowSort(List<Object> entities, List<ImmutablePair<String, Boolean>> orders) {
        Collections.sort(entities, (left, right) -> {
            if (left == null && right == null) {
                return 0;
            }
            if (left == null) {
                return 1;
            }
            if (right == null) {
                return -1;
            }
            Class<?> cls = left.getClass();
            block2: for (Pair order : orders) {
                int compared;
                String[] keys = ((String)order.getKey()).split("\\.");
                boolean asc = (Boolean)order.getValue();
                Class<?> clazz = cls;
                Object rightValue = left;
                Object leftValue = right;
                for (String key : keys) {
                    try {
                        Field field = clazz.getDeclaredField(key);
                        field.setAccessible(true);
                        leftValue = field.get(leftValue);
                        rightValue = field.get(rightValue);
                        if (leftValue == null && rightValue == null) continue block2;
                        if (leftValue == null) {
                            return 1;
                        }
                        if (rightValue == null) {
                            return -1;
                        }
                        clazz = leftValue.getClass();
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        // empty catch block
                    }
                }
                if (!(rightValue instanceof Comparable) || (compared = ((Comparable)rightValue).compareTo(leftValue)) == 0) continue;
                return asc ? compared : -compared;
            }
            return 0;
        });
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CascadeSorter)) {
            return false;
        }
        CascadeSorter other = (CascadeSorter)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ImmutableList this$defaultOrders = this.defaultOrders;
        ImmutableList other$defaultOrders = other.defaultOrders;
        if (this$defaultOrders == null ? other$defaultOrders != null : !this$defaultOrders.equals(other$defaultOrders)) {
            return false;
        }
        ImmutableList this$rules = this.rules;
        ImmutableList other$rules = other.rules;
        return !(this$rules == null ? other$rules != null : !this$rules.equals(other$rules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CascadeSorter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImmutableList $defaultOrders = this.defaultOrders;
        result = result * 59 + ($defaultOrders == null ? 43 : $defaultOrders.hashCode());
        ImmutableList $rules = this.rules;
        result = result * 59 + ($rules == null ? 43 : $rules.hashCode());
        return result;
    }
}

