/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.configure;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class WebConfig
extends WebMvcConfigurerAdapter {
    private static final String MODEL_DEF_PATTERN = "/model-def/**";
    private static final String MODEL_INST_PATTERN = "/model/**";

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping(MODEL_DEF_PATTERN).allowedMethods(new String[]{"GET"});
        registry.addMapping(MODEL_INST_PATTERN).allowedMethods(new String[]{"GET", "POST", "PUT", "DELETE"});
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/ui/**"}).addResourceLocations(new String[]{"classpath:/static/"});
    }

    @Bean
    public RestTemplate getRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        List messageConverters = restTemplate.getMessageConverters();
        int i = messageConverters.size();
        while (i-- > 0) {
            if (!(messageConverters.get(i) instanceof StringHttpMessageConverter)) continue;
            messageConverters.remove(i);
            messageConverters.add(i, new StringHttpMessageConverter(StandardCharsets.UTF_8));
            break;
        }
        return restTemplate;
    }

    @Bean
    public HttpClient getHttpClient() {
        return HttpClients.createDefault();
    }
}

