/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.configure;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.context.annotation.Bean;

@SpringBootConfiguration
public class DataSourceConfiguration {
    @Value(value="${spring.datasource.driver-class-name}")
    private String driver;
    @Value(value="${spring.datasource.url}")
    private String url;
    @Value(value="${spring.datasource.username}")
    private String username;
    @Value(value="${spring.datasource.password}")
    private String password;
    @Value(value="${spring.datasource.poolSize.initial:5}")
    private Integer initialPoolSize;
    @Value(value="${spring.datasource.poolSize.min:5}")
    private Integer minPoolSize;
    @Value(value="${spring.datasource.poolSize.max:20}")
    private Integer maxPoolSize;

    @Bean
    public DataSource getDataSource() throws PropertyVetoException {
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        dataSource.setDriverClass(this.driver);
        dataSource.setJdbcUrl(this.url);
        dataSource.setUser(this.username);
        dataSource.setPassword(this.password);
        dataSource.setAutoCommitOnClose(false);
        int maxPool = Math.max(this.maxPoolSize, 1);
        int minPool = Math.min(this.minPoolSize, maxPool);
        dataSource.setMaxPoolSize(maxPool);
        dataSource.setMinPoolSize(minPool);
        dataSource.setInitialPoolSize(Math.max(Math.min(this.initialPoolSize, maxPool), minPool));
        return dataSource;
    }
}

