/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.configure;

import cn.gtmap.gtc.http.exception.ResourceException;
import cn.gtmap.gtc.model.exception.DatabaseConnectionException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.entity.ContentType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ControllerExceptionHandler {
    private final ObjectMapper objectMapper;

    @Autowired
    public ControllerExceptionHandler(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @ExceptionHandler(value={Exception.class})
    public void getError(HttpServletResponse response, Exception ex) throws IOException {
        response.setContentType(ContentType.APPLICATION_JSON.toString());
        if (ex instanceof ResourceException) {
            ResourceException resourceException = (ResourceException)ex;
            response.setStatus(resourceException.getStatus());
        } else if (ex instanceof DatabaseConnectionException) {
            response.setStatus(HttpStatus.BAD_REQUEST.value());
        } else {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        }
        response.getWriter().write(this.objectMapper.writeValueAsString((Object)ImmutableMap.of((Object)"message", (Object)ex.getMessage())));
    }
}

