/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.aspect;

import cn.gtmap.gtc.model.aspect.EntityMetaModifier;
import cn.gtmap.gtc.model.domain.entity.EntityMeta;
import cn.gtmap.gtc.model.domain.helpers.EntityHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class EntityMetaModifier {
    private static final Logger log = LoggerFactory.getLogger(EntityMetaModifier.class);
    private final List<Consumer<EntityMeta>> validators;

    public EntityMetaModifier() {
        ImmutableMap timeFieldAttributes = ImmutableMap.builder().put((Object)"type", (Object)"timestamp").put((Object)"temporalType", (Object)"TIMESTAMP").put((Object)"dateTimeFormat", (Object)"yyyy-MM-dd HH:MM:SS").build();
        this.validators = ImmutableList.builder().add((Object)new EntityMetaValidator()).add((Object)new EntityMetaEnricher("proId", (Map)ImmutableMap.builder().put((Object)"type", (Object)"string").put((Object)"length", (Object)36).build())).add((Object)new EntityMetaEnricher("createTime", (Map)timeFieldAttributes)).add((Object)new EntityMetaEnricher("modifyTime", (Map)timeFieldAttributes)).add((Object)new EntityMetaEnricher("enabled", (Map)ImmutableMap.builder().put((Object)"type", (Object)"bool").build())).build();
    }

    @Before(value="execution(* cn.gtmap.gtc.model.service.EntityMetaService.*(..))")
    public void addProIdField(JoinPoint joinPoint) {
        this.validators.forEach(this.joinPointToEntityMetas(joinPoint)::forEach);
    }

    private List<EntityMeta> joinPointToEntityMetas(JoinPoint joinPoint) {
        LinkedList<EntityMeta> entityMetas = new LinkedList<EntityMeta>();
        for (Object arg : joinPoint.getArgs()) {
            Map argAsMap;
            if (arg instanceof EntityMeta) {
                entityMetas.add((EntityMeta)arg);
                continue;
            }
            if (arg instanceof Collection) {
                Collection argAsCollection = (Collection)arg;
                if (argAsCollection.isEmpty() || !(argAsCollection.iterator().next() instanceof EntityMeta)) continue;
                entityMetas.addAll(argAsCollection);
                continue;
            }
            if (!(arg instanceof Map) || (argAsMap = (Map)arg).isEmpty() || !(argAsMap.values().iterator().next() instanceof EntityMeta)) continue;
            entityMetas.addAll(argAsMap.values());
        }
        return entityMetas;
    }

    public void touch(Object entity) {
        try {
            Date date = new Date();
            EntityHelper.writeFieldOf((Object)entity, (String)"modifyTime", (Object)date);
            if (null == EntityHelper.readFieldOf((Object)entity, (String)"createTime")) {
                EntityHelper.writeFieldOf((Object)entity, (String)"createTime", (Object)date);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException ex) {
            log.error(ex.getMessage());
        }
    }
}

