/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.formclient.common.dto;

import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;

public class PageInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JSONField(serialize=false)
    private int total;
    @JSONField(serialize=false)
    private int totalPage;
    @JSONField(serialize=false)
    private int offset;
    @JSONField(serialize=false)
    private int limit;
    @JSONField(serialize=false)
    private int current;
    @JSONField(serialize=false)
    private String sort;
    @JSONField(serialize=false)
    private String order;

    public PageInfo() {
    }

    public PageInfo(int limit, int current) {
        this.current = current < 0 ? 1 : current;
        this.limit = limit < 0 ? 1 : limit;
        this.offset = (this.current - 1) * this.limit;
    }

    public PageInfo(int current, int limit, String sort, String order) {
        this.current = current < 0 ? 1 : current;
        this.limit = limit < 0 ? 1 : limit;
        this.offset = (this.current - 1) * this.limit;
        this.sort = sort;
        this.order = order;
    }

    public void count() {
        int plus;
        if (this.limit <= 0) {
            this.limit = 1;
        }
        int totalPageTemp = this.total / this.limit;
        int n = plus = this.total % this.limit == 0 ? 0 : 1;
        if ((totalPageTemp += plus) <= 0) {
            totalPageTemp = 1;
        }
        this.totalPage = totalPageTemp;
    }

    public void current() {
        if (this.limit <= 0) {
            this.limit = 1;
        }
        this.current = this.offset / this.limit + 1;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
        this.count();
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.current();
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }
}

