/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.client;

import cn.gtmap.gtc.model.common.result.BaseResult;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${app.services.model-center}")
@RequestMapping(value={"/model"})
public interface EntityCrudClient {
    @PostMapping(value={"{modelName}"})
    public BaseResult<Object> insert(@PathVariable(value="modelName") String var1, @RequestBody String var2);

    @Deprecated
    default public BaseResult<Object> createEntity(String modelName, String requestBody) {
        return this.insert(modelName, requestBody);
    }

    default public BaseResult<List<Object>> list(String modelName) {
        return this.list(modelName, -1, 0, Collections.emptyMap());
    }

    default public BaseResult<List<Object>> list(String modelName, int pageNumber, int pageSize, Map<String, String> orderBy) {
        return this.list(modelName, null, pageNumber, pageSize, orderBy);
    }

    default public BaseResult<List<Object>> list(String modelName, String proId) {
        return this.list(modelName, proId, -1, 0, Collections.emptyMap());
    }

    @GetMapping(value={"{modelName}"})
    public BaseResult<List<Object>> list(@PathVariable(value="modelName") String var1, @RequestParam(value="proId", required=false) String var2, @RequestParam(value="page", required=false, defaultValue="-1") int var3, @RequestParam(value="size", required=false, defaultValue="20") int var4, @RequestParam Map<String, String> var5);

    @Deprecated
    default public BaseResult<List<Object>> readEntities(String modelName, int pageNumber, int pageSize, String sortBy, Boolean desc) {
        LinkedHashMap<String, String> orderBy = new LinkedHashMap<String, String>();
        if (sortBy != null && !"".equals(sortBy)) {
            orderBy.put(sortBy, Boolean.toString(desc == false));
        }
        return this.list(modelName, pageNumber, pageSize, orderBy);
    }

    @GetMapping(value={"{modelName}/{modelId}"})
    public BaseResult<Object> get(@PathVariable(value="modelName") String var1, @PathVariable(value="modelId") String var2);

    @Deprecated
    default public BaseResult<Object> readEntity(String modelName, String modelId) {
        return this.get(modelName, modelId);
    }

    @PutMapping(value={"{modelName}/{modelId}"})
    public BaseResult<Object> update(@PathVariable(value="modelName") String var1, @PathVariable(value="modelId") String var2, @RequestBody String var3);

    @Deprecated
    default public BaseResult<Object> updateEntity(String modelName, String modelId, String requestBody) {
        return this.update(modelName, modelId, requestBody);
    }

    @PatchMapping(value={"{modelName}/{modelId}"})
    public BaseResult<Object> updateFields(@PathVariable(value="modelName") String var1, @PathVariable(value="modelId") String var2, @RequestBody String var3);

    @DeleteMapping(value={"{modelName}/{modelId}"})
    public BaseResult<Object> delete(@PathVariable(value="modelName") String var1, @PathVariable(value="modelId") String var2);

    @Deprecated
    default public BaseResult<Object> deleteEntity(String modelName, String modelId) {
        return this.delete(modelName, modelId);
    }
}

