/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.gis.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil {
    private static final Logger logger = LoggerFactory.getLogger(ZipUtil.class.getClass());

    private ZipUtil() {
    }

    public static void zipFile(String zip, List<File> srcFiles) {
        if (CollectionUtils.isNotEmpty(srcFiles)) {
            ZipUtil.zipFile(zip, srcFiles.toArray(new File[0]));
        }
    }

    public static void zipFile(String zip, File[] srcFiles) {
        try {
            if (zip.endsWith(".zip") || zip.endsWith(".zip".toUpperCase())) {
                ZipOutputStream zipOut = new ZipOutputStream((OutputStream)new FileOutputStream(new File(zip)));
                zipOut.setEncoding("utf-8");
                for (File _f : srcFiles) {
                    ZipUtil.handlerFile(zip, zipOut, _f, "");
                }
                zipOut.close();
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u538b\u7f29zip\u6587\u4ef6\u65f6\u672a\u627e\u5230\u6307\u5b9a\u6587\u4ef6", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("\u538b\u7f29zip\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handlerFile(String zip, ZipOutputStream zipOut, File srcFile, String path) throws IOException {
        block24: {
            if (!"".equals(path) && !path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            if (srcFile.getPath().equals(zip)) break block24;
            if (srcFile.isDirectory()) {
                File[] files = srcFile.listFiles();
                if (files.length == 0) {
                    zipOut.putNextEntry(new ZipEntry(path + srcFile.getName() + File.separator));
                    zipOut.closeEntry();
                } else {
                    for (File file : files) {
                        ZipUtil.handlerFile(zip, zipOut, file, path + srcFile.getName());
                    }
                }
            } else {
                try (FileInputStream inputStream = new FileInputStream(srcFile);){
                    zipOut.putNextEntry(new ZipEntry(path + srcFile.getName()));
                    int len = 0;
                    byte[] bytes = new byte[1024];
                    while ((len = ((InputStream)inputStream).read(bytes)) > 0) {
                        zipOut.write(bytes, 0, len);
                    }
                }
                catch (IOException e) {
                    logger.error(e.toString());
                }
                finally {
                    zipOut.closeEntry();
                }
            }
        }
    }

    public static void zipFile(String zip, List<File> files, List<String> fileNameList) {
        try {
            if (zip.endsWith(".zip") || zip.endsWith(".zip".toUpperCase())) {
                ZipOutputStream zipOut = new ZipOutputStream((OutputStream)new FileOutputStream(new File(zip)));
                zipOut.setEncoding("utf-8");
                for (int i = 0; i < files.size(); ++i) {
                    ZipUtil.handlerFile(zipOut, files.get(i), "", fileNameList.get(i));
                }
                zipOut.close();
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u538b\u7f29zip\u6587\u4ef6\u65f6\u672a\u627e\u5230\u6307\u5b9a\u6587\u4ef6", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("\u538b\u7f29zip\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handlerFile(ZipOutputStream zipOut, File srcFile, String path, String fileName) throws IOException {
        if (!"".equals(path) && !path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        zipOut.putNextEntry(new ZipEntry(path + fileName));
        int len = 0;
        byte[] bytes = new byte[1024];
        try (FileInputStream inputStream = new FileInputStream(srcFile);){
            while ((len = inputStream.read(bytes)) > 0) {
                zipOut.write(bytes, 0, len);
            }
        }
        catch (IOException e) {
            logger.error(e.toString());
        }
        finally {
            zipOut.closeEntry();
        }
    }

    public static List<File> upzipFile(String zipPath, String descDir) {
        return ZipUtil.upzipFile(new File(zipPath), descDir);
    }

    public static List<File> upzipFile(File zipFile, String descDir) {
        ArrayList<File> list = new ArrayList<File>();
        try (ZipFile newZipFile = new ZipFile(zipFile, "utf-8");){
            Enumeration entries = newZipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)entries.nextElement();
                File file = new File(descDir + File.separator + entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try (InputStream inputStream = newZipFile.getInputStream(entry);
                     FileOutputStream outputStream = new FileOutputStream(file);){
                    byte[] bytes = new byte[1024];
                    int len = 0;
                    while ((len = inputStream.read(bytes)) > 0) {
                        ((OutputStream)outputStream).write(bytes, 0, len);
                    }
                }
                catch (IOException e) {
                    logger.error(e.toString());
                }
                list.add(file);
            }
        }
        catch (IOException e) {
            logger.error("\u89e3\u538b\u7f29zip\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return list;
    }

    public static File doZip(String zipDirectory, String zipPath) {
        File zipDir = new File(zipDirectory);
        if (zipPath == null) {
            zipPath = zipDir.getParent();
        }
        String zipFileName = zipPath + File.separator + zipDir.getName() + ".zip";
        try {
            ZipOutputStream zipOut = new ZipOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(zipFileName)));
            ZipUtil.handleDir(zipDir, zipDir.getParent().length() + 1, zipOut);
            zipOut.close();
            return new File(zipFileName);
        }
        catch (IOException e) {
            logger.error(e.toString());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleDir(File dir, int len, ZipOutputStream zipOut) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            if (files.length > 0) {
                for (File fileName : files) {
                    if (fileName.isDirectory()) {
                        ZipUtil.handleDir(fileName, len, zipOut);
                        continue;
                    }
                    try (FileInputStream fileIn = new FileInputStream(fileName);){
                        int readedBytes;
                        byte[] buf = new byte[fileIn.available()];
                        zipOut.putNextEntry(new ZipEntry(fileName.getPath().substring(len + dir.getName().length()).replaceAll("\\\\", "")));
                        while ((readedBytes = fileIn.read(buf)) > 0) {
                            zipOut.write(buf, 0, readedBytes);
                        }
                    }
                    catch (IOException e) {
                        logger.error(e.toString());
                    }
                    finally {
                        zipOut.closeEntry();
                    }
                }
            } else {
                zipOut.putNextEntry(new ZipEntry(dir.getPath().substring(len) + "/"));
                zipOut.closeEntry();
            }
        } else {
            try (FileInputStream fileIn = new FileInputStream(dir);){
                int readedBytes;
                byte[] buf = new byte[fileIn.available()];
                zipOut.putNextEntry(new ZipEntry(dir.getPath().substring(len)));
                while ((readedBytes = fileIn.read(buf)) > 0) {
                    zipOut.write(buf, 0, readedBytes);
                }
            }
            catch (IOException e) {
                logger.error(e.toString());
            }
            finally {
                zipOut.closeEntry();
            }
        }
    }
}

