/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.gis.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public final class ArrayUtils {
    public static final String DEFAULT_SEPARATOR = ",";

    public static final boolean empty(String[] values) {
        if (values == null) {
            return true;
        }
        for (String value : values) {
            if (!StringUtils.isNotBlank((String)value)) continue;
            return false;
        }
        return true;
    }

    public static final boolean contains(String[] src, String des, boolean ignoreCase) {
        for (String item : src) {
            if (!StringUtils.isNotBlank((String)item) || !StringUtils.isNotBlank((String)des) || !(ignoreCase ? item.equalsIgnoreCase(des) : item.equals(des))) continue;
            return true;
        }
        return false;
    }

    public static final String[] add2Arrays(String[] des, String src) {
        if (des == null) {
            return new String[]{src};
        }
        String[] tmp = new String[des.length + 1];
        System.arraycopy(des, 0, tmp, 0, des.length);
        tmp[des.length] = src;
        return tmp;
    }

    public static final String[] add2Arrays(String[] des, String[] src) {
        if (des == null) {
            return src;
        }
        if (src == null) {
            return des;
        }
        String[] tmp = new String[des.length + src.length];
        System.arraycopy(src, 0, tmp, 0, src.length);
        System.arraycopy(des, 0, tmp, src.length, des.length);
        return tmp;
    }

    public static final String[] remove2Arrays(String[] src, String[] removesrc) {
        if (src == null || removesrc == null) {
            return src;
        }
        List<String> tempList = Arrays.asList(src);
        ArrayList<String> newList = new ArrayList<String>(tempList);
        for (int i = newList.size() - 1; i >= 0; --i) {
            String temp = (String)newList.get(i);
            for (int j = 0; j < removesrc.length; ++j) {
                if (!StringUtils.equals((String)temp, (String)removesrc[j])) continue;
                newList.remove(i);
            }
        }
        String[] result = new String[src.length - removesrc.length];
        return newList.toArray(result);
    }

    public static String arrayToString(String[] ig, String separator) {
        StringBuilder sb = new StringBuilder();
        if (ig != null && ig.length > 0) {
            for (int i = 0; i < ig.length; ++i) {
                sb.append(ig[i]).append(separator == null ? separator : DEFAULT_SEPARATOR);
            }
        }
        String str = sb.toString();
        str = StringUtils.isNotBlank((String)separator) ? str.substring(0, str.length() - separator.length()) : str.substring(0, str.length());
        return str;
    }

    public static String listToString(List list, String separator) {
        StringBuilder sb = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                if (i <= list.size() - 2) {
                    sb.append(list.get(i));
                    sb.append(separator != null ? separator : DEFAULT_SEPARATOR);
                    continue;
                }
                sb.append(list.get(i));
            }
        }
        return sb.toString();
    }

    public static Map listConvertMap(List list, String groupKey) {
        if (list == null || groupKey == null) {
            return null;
        }
        HashMap<String, List> map = new HashMap<String, List>();
        if (!list.isEmpty()) {
            for (Object obj : list) {
                Map item = (Map)obj;
                if (!item.containsKey(groupKey)) continue;
                String key = MapUtils.getString((Map)item, (Object)groupKey);
                if (map.containsKey(key)) {
                    List list1 = (List)map.get(key);
                    list1.add(item);
                    map.put(key, list1);
                    continue;
                }
                ArrayList<Map> list2 = new ArrayList<Map>();
                list2.add(item);
                map.put(key, list2);
            }
            return map;
        }
        return null;
    }

    public static Map listConvertLinkedMap(List<Map> list, String groupKey) {
        if (list == null || groupKey == null) {
            return null;
        }
        LinkedHashMap<String, List> map = new LinkedHashMap<String, List>();
        if (!list.isEmpty()) {
            for (Map item : list) {
                String key = MapUtils.getString((Map)item, (Object)groupKey);
                if (map.containsKey(key)) {
                    List list1 = (List)map.get(key);
                    list1.add(item);
                    map.put(key, list1);
                    continue;
                }
                ArrayList<Map> list2 = new ArrayList<Map>();
                list2.add(item);
                map.put(key, list2);
            }
            return map;
        }
        return null;
    }

    public static List mapConvertList(Map map, TYPE type) {
        if (map == null || type == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        if (type.equals((Object)TYPE.KEY)) {
            for (Object key : map.keySet()) {
                list.add(key);
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                Object val = entry.getValue();
                list.add(val == null ? "" : val);
            }
        }
        return list;
    }

    public static List convertToList(String src) {
        Object[] fields = StringUtils.isNotBlank((String)src) ? new String[]{} : src.split(DEFAULT_SEPARATOR);
        return Lists.newArrayList((Object[])fields);
    }

    public static List convertToList(String[] src) {
        return Lists.newArrayList((Object[])src);
    }

    public static enum TYPE {
        KEY,
        VALUE;

    }
}

