/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.gis.support.http;

import cn.gtmap.gtc.gis.support.http.FormFieldKeyValuePair;
import cn.gtmap.gtc.gis.support.http.MultiPartFileItem;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultiPartRequestEmulator {
    public static final String BOUNDARY = "----------HV2ymHFg03ehbqgZCaKO6jyH";
    private static final Logger logger = LoggerFactory.getLogger(MultiPartRequestEmulator.class);
    public static final String UTF_8 = "utf-8";

    public static String sendPostRequest(String serverUrl, List<FormFieldKeyValuePair> generalFormFields, List<MultiPartFileItem> filesToBeUploaded) throws Exception {
        MultiPartRequestEmulator.trustAllHttpsCertificates();
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                logger.warn("Warning: URL Host: " + urlHostName + " vs. " + session.getPeerHost());
                return true;
            }
        });
        URL url = new URL(serverUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Charset", UTF_8);
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=----------HV2ymHFg03ehbqgZCaKO6jyH");
        String boundary = BOUNDARY;
        StringBuilder contentBody = new StringBuilder("------------HV2ymHFg03ehbqgZCaKO6jyH");
        String endBoundary = "\r\n--" + boundary + "--\r\n";
        OutputStream out = connection.getOutputStream();
        for (FormFieldKeyValuePair formFieldKeyValuePair : generalFormFields) {
            contentBody.append("\r\n").append("Content-Disposition: form-data; name=\"").append(formFieldKeyValuePair.getKey() + "\"").append("\r\n").append("\r\n").append(formFieldKeyValuePair.getValue()).append("\r\n").append("--").append(boundary);
        }
        String boundaryMessage1 = contentBody.toString();
        out.write(boundaryMessage1.getBytes(UTF_8));
        for (MultiPartFileItem ufi : filesToBeUploaded) {
            contentBody = new StringBuilder();
            contentBody.append("\r\n").append("Content-Disposition:form-data; name=\"").append(ufi.getFormFieldName() + "\"; ").append("filename=\"").append(ufi.getFileName() + "\"").append("\r\n").append("Content-Type:application/octet-stream").append("\r\n\r\n");
            String boundaryMessage2 = contentBody.toString();
            out.write(boundaryMessage2.getBytes(UTF_8));
            out.write(ufi.getContent());
            contentBody.append(BOUNDARY);
            String boundaryMessage = contentBody.toString();
            out.write(boundaryMessage.getBytes(UTF_8));
        }
        out.write(BOUNDARY.concat("\r\n").getBytes(UTF_8));
        out.write(endBoundary.getBytes(UTF_8));
        out.flush();
        out.close();
        InputStream inputStream = connection.getInputStream();
        return IOUtils.toString((InputStream)inputStream, (String)UTF_8);
    }

    public static void trustAllHttpsCertificates() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[1];
        MyTrustManager tm = new MyTrustManager();
        trustAllCerts[0] = tm;
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    static class MyTrustManager
    implements TrustManager,
    X509TrustManager {
        MyTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        public boolean isServerTrusted(X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] certs) {
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

