/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.gis.domain.sde;

import java.io.Serializable;
import java.util.List;

public class PageBean<T>
implements Serializable {
    private Integer pageSize;
    private Integer currentPage;
    private Integer totalPage;
    private Integer totalRecord;
    private List<T> dataList;

    public PageBean() {
    }

    public PageBean(Integer pageNum, Integer pageSize, List<T> sourceList) {
        this.totalRecord = sourceList.size();
        this.pageSize = pageSize;
        this.totalPage = (this.totalRecord + this.pageSize - 1) / this.pageSize;
        pageNum = pageNum >= 1 ? pageNum : 1;
        this.currentPage = pageNum >= this.totalPage ? this.totalPage : pageNum;
        Integer fromIndex = (this.currentPage - 1) * this.pageSize;
        Integer toIndex = this.pageSize * this.currentPage >= this.totalRecord ? this.totalRecord : this.pageSize * this.currentPage;
        this.dataList = sourceList.subList(fromIndex, toIndex);
    }

    public PageBean(Integer currentPage, Integer pageSize, Integer totalRecord, List<T> dataList) {
        this.pageSize = pageSize;
        this.currentPage = currentPage;
        this.totalPage = (totalRecord + pageSize - 1) / pageSize;
        this.totalRecord = totalRecord;
        this.dataList = dataList;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public Integer getTotalPage() {
        return this.totalPage;
    }

    public Integer getTotalRecord() {
        return this.totalRecord;
    }

    public List<T> getDataList() {
        return this.dataList;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public void setTotalPage(Integer totalPage) {
        this.totalPage = totalPage;
    }

    public void setTotalRecord(Integer totalRecord) {
        this.totalRecord = totalRecord;
    }

    public void setDataList(List<T> dataList) {
        this.dataList = dataList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageBean)) {
            return false;
        }
        PageBean other = (PageBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Integer this$currentPage = this.getCurrentPage();
        Integer other$currentPage = other.getCurrentPage();
        if (this$currentPage == null ? other$currentPage != null : !((Object)this$currentPage).equals(other$currentPage)) {
            return false;
        }
        Integer this$totalPage = this.getTotalPage();
        Integer other$totalPage = other.getTotalPage();
        if (this$totalPage == null ? other$totalPage != null : !((Object)this$totalPage).equals(other$totalPage)) {
            return false;
        }
        Integer this$totalRecord = this.getTotalRecord();
        Integer other$totalRecord = other.getTotalRecord();
        if (this$totalRecord == null ? other$totalRecord != null : !((Object)this$totalRecord).equals(other$totalRecord)) {
            return false;
        }
        List<T> this$dataList = this.getDataList();
        List<T> other$dataList = other.getDataList();
        return !(this$dataList == null ? other$dataList != null : !((Object)this$dataList).equals(other$dataList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Integer $currentPage = this.getCurrentPage();
        result = result * 59 + ($currentPage == null ? 43 : ((Object)$currentPage).hashCode());
        Integer $totalPage = this.getTotalPage();
        result = result * 59 + ($totalPage == null ? 43 : ((Object)$totalPage).hashCode());
        Integer $totalRecord = this.getTotalRecord();
        result = result * 59 + ($totalRecord == null ? 43 : ((Object)$totalRecord).hashCode());
        List<T> $dataList = this.getDataList();
        result = result * 59 + ($dataList == null ? 43 : ((Object)$dataList).hashCode());
        return result;
    }

    public String toString() {
        return "PageBean(pageSize=" + this.getPageSize() + ", currentPage=" + this.getCurrentPage() + ", totalPage=" + this.getTotalPage() + ", totalRecord=" + this.getTotalRecord() + ", dataList=" + this.getDataList() + ")";
    }
}

