package cn.gtmap.gtc.gis.domain.data.analysis;

import com.alibaba.fastjson.JSON;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 界址点图形对象
 * Author: <a href="mailto:yingxiufeng@gtmap.cn">yingxiufeng</a>
 * Date:  2016/6/22 14:11
 */
public class BMarkGeometry implements Serializable {

    private static final long serialVersionUID = -2007270576071500200L;

    /**
     * 界址点坐标
     */
    private List<BMark> bMarks;

    /**
     * 界址点图形的属性信息
     */
    private Map attributes;

    public BMarkGeometry() {
    }

    public BMarkGeometry(List<BMark> bMarks) {
        this.bMarks = bMarks;
    }

    public BMarkGeometry(List<BMark> bMarks, Map attributes) {
        this.bMarks = bMarks;
        this.attributes = attributes;
    }

    public List<BMark> getbMarks() {
        return bMarks;
    }

    public void setbMarks(List<BMark> bMarks) {
        this.bMarks = bMarks;
    }

    public Map getAttributes() {
        return attributes;
    }

    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    /***
     * to json
     * @return
     */
    public String toJsonString() {
        return JSON.toJSONString(this);
    }
}
