package cn.gtmap.gtc.gis.domain.data.analysis;

import java.io.Serializable;

/**
 * 界址点实体类
 * 仅保留和图形相关的属性
 * Author: <a href="mailto:yingxiufeng@gtmap.cn">yingxiufeng</a>
 * Date:  2016/6/15 21:13
 */
public class BMark implements Comparable<BMark>, Serializable {

    private static final long serialVersionUID = -8813834872181128L;

    /***
     * pcd id
     */
    private String pcdId;
    /***
     * sb id
     */
    private String sbId;

    /***
     * 点序号
     */
    private Integer pntIndex;

    /***
     * x坐标
     */
    private double xCoord;

    /***
     * y坐标
     */
    private double yCoord;

    /***
     * 环号
     */
    private Integer roundNo;

    /***
     * 多边形号
     */
    private Integer polygonNo;

    /***
     * border length
     */
    private double borderLength;

    public BMark(Integer pntIndex, Integer roundNo, Integer polygonNo, double xCoord, double yCoord) {
        this.pntIndex = pntIndex;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.roundNo = roundNo;
        this.polygonNo = polygonNo;
    }

    public BMark() {
    }

    public String getPcdId() {
        return pcdId;
    }

    public void setPcdId(String pcdId) {
        this.pcdId = pcdId;
    }

    public String getSbId() {
        return sbId;
    }

    public void setSbId(String sbId) {
        this.sbId = sbId;
    }

    public Integer getPntIndex() {
        return pntIndex;
    }

    public void setPntIndex(Integer pntIndex) {
        this.pntIndex = pntIndex;
    }

    public double getxCoord() {
        return xCoord;
    }

    public void setxCoord(double xCoord) {
        this.xCoord = xCoord;
    }

    public double getyCoord() {
        return yCoord;
    }

    public void setyCoord(double yCoord) {
        this.yCoord = yCoord;
    }

    public Integer getRoundNo() {
        return roundNo;
    }

    public void setRoundNo(Integer roundNo) {
        this.roundNo = roundNo;
    }

    public Integer getPolygonNo() {
        return polygonNo;
    }

    public void setPolygonNo(Integer polygonNo) {
        this.polygonNo = polygonNo;
    }

    public double getBorderLength() {
        return borderLength;
    }

    public void setBorderLength(double borderLength) {
        this.borderLength = borderLength;
    }

    @Override
    public int compareTo(BMark bMark) {
        return this.getPntIndex() - bMark.getPntIndex();
    }

}
