package cn.gtmap.gtc.gis.clients.sde;

import cn.gtmap.gtc.gis.domain.data.search.ResultBean;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author panrong
 */
@FeignClient(name = "${app.services.gis-sde-download:gis-sde-download}")
@RequestMapping("/rest/sde")
@Component
public interface SdeDownloadClient {


    /**
     * 多图层按属性查询下载
     *
     * @param taskIds
     * @param layerNames
     * @param wheres
     * @param columns
     * @param dataSource
     * @return
     * @Param taskIds
     */
    @PostMapping(value = "/query/attribute/download")
    ResultBean queryDownloadByAttribute(@RequestParam("taskIds") String taskIds,
                                        @RequestParam("layerNames") String layerNames,
                                        @RequestParam(value = "fileNames", required = false, defaultValue = "") String fileNames,
                                        @RequestParam(value = "wheres", required = false, defaultValue = "") String wheres,
                                        @RequestParam(value = "columns", required = false, defaultValue = "") String columns,
                                        @RequestParam(value = "dataSource", defaultValue = "") String dataSource);


    /**
     * 多图层按空间属性联合查询下载
     *
     * @param params
     * @return
     */
    @PostMapping(value = "/query/space/download")
    ResultBean queryDownloadBySpaceAttribute(@RequestBody Map params);

    /**
     * 多图层按对应属性条件查询下载
     *
     * @param taskIds
     */
    @GetMapping("/query/task/result")
    List<ResultBean> getQueryResult(@RequestParam("taskIds") String taskIds);

}
