package cn.gtmap.gtc.gis.clients.sde;

import cn.gtmap.gtc.gis.domain.data.search.ResultBean;
import cn.gtmap.gtc.gis.domain.esm.FeatureCollection;
import cn.gtmap.gtc.gis.domain.sde.LayerRegionC;
import cn.gtmap.gtc.gis.domain.sde.PageBean;
import cn.gtmap.gtc.gis.domain.sde.QueryParams;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author panrong
 */
@FeignClient(name = "${app.services.gis-sde:gis-sde}")
@RequestMapping("/rest/sde")
@Component
public interface SdeClient {

    /**
     * 查询接口
     *
     * @param layerName      空间数据图层名称
     * @param where          Where 查询条件
     * @param geometry       GeoJSON 格式图形
     * @param outFields      返回字段
     * @param returnGeometry 是否返回图形
     * @param dataSource     数据源
     * @return
     */
    @RequestMapping(value = "/query")
    public Map query(@RequestParam("layerName") String layerName,
                     @RequestParam(value = "where", required = false) String where,
                     @RequestParam(value = "geometry", required = false) String geometry,
                     @RequestParam(value = "outFields", defaultValue = "*") String outFields,
                     @RequestParam(value = "returnGeometry", defaultValue = "true") boolean returnGeometry,
                     @RequestParam(value = "dataSource", defaultValue = "") String dataSource);

    /**
     * 查询接口接收大数据量改造
     *
     * @param map
     * @return
     */
    @PostMapping(value = "/query2")
    public Map query(@RequestBody Map map);


    /**
     * 按属性查询图层统计信息
     *
     * @param layerName
     * @param where
     * @param dataSource
     * @return
     */
    @RequestMapping("/query/attStates")
    Map<String, Object> attStates(@RequestParam("layerName") String layerName,
                                  @RequestParam(value = "where", required = false) String where,
                                  @RequestParam(value = "dataSource", defaultValue = "") String dataSource);


    /**
     * 查询图层属性值
     *
     * @param layerName
     * @param where
     * @param columns
     * @param dataSource
     * @return
     */
    @RequestMapping("/query/properties")
    List queryProperties(@RequestParam("layerName") String layerName,
                         @RequestParam(value = "where", required = false) String where,
                         @RequestParam(value = "columns", required = false) String[] columns,
                         @RequestParam(value = "dataSource", defaultValue = "") String dataSource);


    /**
     * 按属性查询图层
     *
     * @param layerName
     * @param where
     * @param columns
     * @param returnGeometry
     * @param dataSource
     * @return
     */
    @RequestMapping("/query/attribute")
    FeatureCollection query(@RequestParam("layerName") String layerName,
                            @RequestParam(value = "where", required = false) String where,
                            @RequestParam(value = "columns", required = false) String[] columns,
                            @RequestParam(value = "returnGeometry", defaultValue = "true") boolean returnGeometry,
                            @RequestParam(value = "dataSource", defaultValue = "") String dataSource);

    /**
     * 按空间查询图层
     *
     * @param layerName
     * @param wkt
     * @param columns
     * @param dataSource
     * @return
     */
    @PostMapping(value = "/query/space")
    FeatureCollection query(@RequestParam("layerName") String layerName,
                            @RequestBody String wkt,
                            @RequestParam(value = "columns", required = false) String[] columns,
                            @RequestParam(value = "dataSource", defaultValue = "") String dataSource);

    /**
     * 分析空间查询参数过大使用
     *
     * @param params
     * @return
     */
    @PostMapping(value = "/query/space2")
    FeatureCollection query2(@RequestBody QueryParams params);

//    /**
//     * 多图层按属性查询下载
//     *
//     * @param taskIds
//     * @param layerNames
//     * @param wheres
//     * @param columns
//     * @param dataSource
//     * @return
//     * @Param taskIds
//     */
//    @PostMapping(value = "/query/attribute/download")
//    ResultBean queryDownloadByAttribute(@RequestParam("taskIds") String taskIds,
//                                        @RequestParam("layerNames") String layerNames,
//                                        @RequestParam(value = "fileNames", required = false, defaultValue = "") String fileNames,
//                                        @RequestParam(value = "wheres", required = false, defaultValue = "") String wheres,
//                                        @RequestParam(value = "columns", required = false, defaultValue = "") String columns,
//                                        @RequestParam(value = "dataSource", defaultValue = "") String dataSource);
//
//
//    /**
//     * 多图层按空间属性联合查询下载
//     *
//     * @param params
//     * @return
//     */
//    @PostMapping(value = "/query/space/download")
//    ResultBean queryDownloadBySpaceAttribute(@RequestBody Map params);
//
//    /**
//     * 多图层按对应属性条件查询下载
//     *
//     * @param taskIds
//     */
//    @GetMapping("/query/task/result")
//    List<ResultBean> getQueryResult(@RequestParam("taskIds") String taskIds);


    /**
     * 获取图层空间参考
     *
     * @param layerName
     * @param dataSource
     * @return
     */
    @RequestMapping("/CoordinateReferenceSystem")
    String getLayerCRS(@RequestParam("layerName") String layerName,
                       @RequestParam("dataSource") String dataSource);

    @RequestMapping("/getLayerRegion")
    LayerRegionC getLayerRegion(@RequestParam("layerName") String layerName);

    @RequestMapping("/getLayerColumns")
    String[] getLayerColumns(@RequestParam("layerName") String layerName,
                             @RequestParam("dataSource") String dataSource);

    /**
     * 空间属性联合查询图层
     *
     * @param layerName
     * @param wkt
     * @param where
     * @param columns
     * @param dataSource
     * @return
     */
    @RequestMapping("/query/spaceAttribute")
    FeatureCollection query(@RequestParam("layerName") String layerName,
                            @RequestParam(value = "wkt") String wkt,
                            @RequestParam(value = "where") String where,
                            @RequestParam(value = "columns", required = false) String[] columns,
                            @RequestParam(value = "dataSource", defaultValue = "") String dataSource);

    /**
     * get crs by reset regionCode sets
     *
     * @param regionCode
     * @return
     */
    @RequestMapping("/getCRSByRegionCode")
    String getCRSByRegionCode(@RequestParam("regionCode") String regionCode);

    /**
     * 此接口用于数据下载中的图层校验
     * 此接口的使用前提是：不存在不同数据源但是用户相同的情况
     *
     * @param layerName user.table
     * @return
     */
    @RequestMapping("/checkLayer")
    boolean checkLayer(@RequestParam("layerName") String layerName);

    /**
     * 获取数据源的图层列表
     *
     * @param dataSource
     * @return
     */
    @RequestMapping("/getLayers")
    List<String> getLayers(@RequestParam("dataSource") String dataSource);

    /**
     * 获取数据源的图层列表
     *
     * @param dataSource
     * @return
     */
    @RequestMapping("/getTables")
    List<String> getTables(@RequestParam("dataSource") String dataSource, @RequestParam(value = "permissions", required = false, defaultValue = "2") int permissions);

    /**
     * 监测图层是否存在
     *
     * @param layerName
     * @param dbSource
     * @return
     */
    @RequestMapping("/spatialDao/detectLayer")
    boolean detectLayer(@RequestParam("layerName") String layerName,
                        @RequestParam("dbSource") String dbSource);

    /**
     * 根据坐标中心的X坐标获取坐标系信息
     *
     * @param x
     * @return
     */
    @RequestMapping("/getCrsByCoordX")
    Map getCrsByCoordX(@RequestParam("x") double x);

    /**
     * default crs
     *
     * @return
     */
    @RequestMapping("/getDefaultCrs")
    String getDefaultCrs();

    /**
     * 获取资源列表
     *
     * @return
     */
    @RequestMapping("/getDataSourceList")
    List<String> getDataSourceList();

    /**
     * 获取sde图层所选范围内是否完全包含输入geometry
     * 为省厅分析前检查分析图形是否在行政区范围内
     *
     * @param params
     * @return
     */
    @PostMapping(value = "/inBound")
    Map inBound(@RequestBody Map params);

    /**
     * 插入要素
     *
     * @param layerName
     * @param geometry   GeoJSON 格式要素
     * @param dataSource
     * @return
     */
    @RequestMapping(value = "/insert")
    Map insert(@RequestParam("layerName") String layerName,
               @RequestParam(value = "geometry", required = false) String geometry,
               @RequestParam(value = "check", required = false, defaultValue = "false") Boolean check,
               @RequestParam(value = "dataSource", defaultValue = "") String dataSource);

    /**
     * 插入要素
     *
     * @param params
     * @return
     */
    @PostMapping(value = "/insert2")
    Map insert2(@RequestBody Map params);

    /**
     * 更新要素
     *
     * @param layerName
     * @param primaryKey
     * @param geometry   GeoJSON 格式要素
     * @param dataSource
     * @return
     */
    @RequestMapping(value = "/update")
    Map update(@RequestParam("layerName") String layerName,
               @RequestParam(value = "primaryKey") String primaryKey,
               @RequestParam(value = "geometry") String geometry,
               @RequestParam(value = "dataSource", defaultValue = "") String dataSource);

    /**
     * 根据条件更新属性
     *
     * @param layerName
     * @param where
     * @param properties
     * @param dataSource
     * @return
     */
    @RequestMapping(value = "/update2")
    Map update2(@RequestParam("layerName") String layerName,
                @RequestParam(value = "where") String where,
                @RequestParam(value = "properties") String properties,
                @RequestParam(value = "dataSource", defaultValue = "") String dataSource);

    /**
     * 删除要素
     *
     * @param layerName
     * @param primaryKey 要素主键
     * @param dataSource
     * @return
     */
    @RequestMapping(value = "/delete")
    Map delete(@RequestParam("layerName") String layerName,
               @RequestParam(value = "primaryKey") String primaryKey,
               @RequestParam(value = "dataSource", defaultValue = "") String dataSource);

    /**
     * 删除要素
     *
     * @param layerName
     * @param where      属性条件
     * @param dataSource
     * @return
     */
    @RequestMapping(value = "/deleteByWhere")
    public Map deleteByWhere(@RequestParam("layerName") String layerName,
                             @RequestParam("where") String where,
                             @RequestParam(value = "dataSource", defaultValue = "") String dataSource);

    /**
     * get crs by point
     *
     * @param wkt
     * @return
     */
    @PostMapping("/getCrsByGeoPoint")
    Map getCrsByGeoPoint(@RequestBody String wkt);

    /**
     * 判断wkt能否在sde中进行分析
     *
     * @param params
     * @return
     */
    @PostMapping("/isWktValid")
    Map isWktValid(@RequestBody Map params);

    /**
     * 查询空间操作日志
     *
     * @param dataSource
     * @param layerName
     * @param events
     * @param start
     * @param end
     * @param status
     * @param kv
     * @param pageIndex
     * @param pageSize
     * @return
     */
    @GetMapping("/spatialDao/log")
    PageBean getSpatialDaoLog(@RequestParam(name = "dataSource", required = false) String dataSource,
                              @RequestParam(name = "layerName", required = false) String layerName,
                              @RequestParam(name = "projectName", required = false) String projectName,
                              @RequestParam(name = "events", required = false) String events,
                              @RequestParam(name = "start", required = false) Long start,
                              @RequestParam(name = "end", required = false) Long end,
                              @RequestParam(name = "status", required = false) Boolean status,
                              @RequestParam(name = "kv", required = false) String kv,
                              @RequestParam(name = "pageIndex", required = false, defaultValue = "1") Integer pageIndex,
                              @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize);
}
