package cn.gtmap.gtc.gis.clients.data.search;

import cn.gtmap.gtc.gis.domain.esm.FeatureCollection;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * .GeoJsonTransformClient
 *
 * @author <a href="mailto:yingxiufeng@gtmap.cn">alex.y</a>
 * @version v1.0, 2018/5/7 (c) Copyright gtmap Corp.
 */
@FeignClient(name="${app.services.gis-search:gis-search}")
@RequestMapping("/geojson/transform")
public interface GeoJsonTransformClient {

    @RequestMapping(value = "/toShpZip",method = RequestMethod.POST)
    byte[] toShpZip(@RequestBody String geometry);

    @RequestMapping(value = "/fromZip",method = RequestMethod.POST)
    List<FeatureCollection> fromZip(@RequestParam("file") MultipartFile file);
}
