package cn.gtmap.gtc.gis.clients.data.search;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author Fjj
 * @date 2018/6/6
 */
@FeignClient(name = "${app.services.gis-search:gis-search}")
@RequestMapping("/es/{name}/rest")
public interface EsRestClient {

    /**
     * 校验geometry数据是否在regionCode指定的行政区划范围内
     *
     * @param params
     * @return
     */
    @PostMapping({"/checkGeometry"})
    boolean checkGeometry(@RequestBody Map params, @PathVariable("name") String name);

    /**
     * 查询
     *
     * @param params
     * @return
     */
    @GetMapping({"/query"})
    String query(@RequestParam Map<String, String> params, @PathVariable("name") String name);

}
