package cn.gtmap.gtc.gis.clients.data.search;

import cn.gtmap.gtc.gis.domain.data.search.GeometryQueryBean;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * Created by Fjj on 2017/11/21.
 * elasticsearch中图层的几何查询
 */
@FeignClient(name="${app.services.gis-search:gis-search}")
@RequestMapping("/es/{name}/query/original/geometry")
public interface EsGeometryQueryOriginalClient {

    /**
     * 几何查询
     *
     * @param queryBean example({"geometry":{"type": "envelope","coordinates" : [[112, 34.0], [119.81, 34.8]]},"page":2,"size":20})
     * @param name      index name
     * @param operate   支持intersects、within、contains、disjoint
     * @return
     */
    @PostMapping(value = "/{operate}")
    String query(@RequestBody GeometryQueryBean queryBean, @PathVariable("name") String name, @PathVariable("operate") String operate);
}
