package cn.gtmap.gtc.gis.clients.data.search;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

/**
 * Created by Fjj on 2017/11/21.
 * elasticsearch中图层的属性查询
 */
@FeignClient(name="${app.services.gis-search:gis-search}")
@RequestMapping("/es/{name}/query/original/attribute")
public interface EsAttributeQueryOriginalClient {

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @GetMapping({"/byid"})
    String queryById(String id, @PathVariable("name") String name);

    /**
     * 精确查询(各查询条件之间是and关系)
     *
     * @param params
     * @param name
     * @return
     */
    @GetMapping({"/exact"})
    String exactQuery(@RequestParam Map<String, String> params, @PathVariable("name") String name);

    /**
     * like查询(各查询条件间and关系)
     *
     * @param params
     * @param name
     * @return
     */
    @GetMapping({"/andlike"})
    String andLikeQuery(@RequestParam Map<String, String> params, @PathVariable("name") String name);


    /**
     * like查询(各查询条件间or关系)
     *
     * @param params
     * @param name
     * @return
     */
    @GetMapping({"/orlike"})
    String orLikeQuery(@RequestParam Map<String, String> params, @PathVariable("name") String name);

    /**
     * match查询(各查询条件间or关系)
     *
     * @param params
     * @param name
     * @return
     */
    @GetMapping({"/match"})
    String matchQuery(@RequestParam Map<String, String> params, @PathVariable("name") String name);

}
