package cn.gtmap.gtc.gis.clients.cluster;

import cn.gtmap.gtc.gis.domain.cluster.ArcgisServiceDetailResponse;
import cn.gtmap.gtc.gis.domain.cluster.ArcgisServicesResponse;
import cn.gtmap.gtc.gis.domain.cluster.GisNode;
import cn.gtmap.gtc.gis.domain.data.search.ResultBean;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Created by Fjj on 2017/12/7.
 */
@FeignClient(name="${app.services.gis-cluster:gis-cluster}")
@RequestMapping("/rest/node")
public interface GisNodeClient {

    /**
     * 查询集群下所有节点信息
     *
     * @return
     */
    @GetMapping({"/querybyclusterid"})
    List<GisNode> queryByClusterId(@RequestParam(name = "clusterid") String clusterId);

    /**
     * 查询指定id的节点
     *
     * @param id
     * @return
     */
    @GetMapping({"/querybyid"})
    GisNode queryById(@RequestParam(name = "id") String id);

    /**
     * 查询指定名称的节点
     *
     * @param name
     * @return
     */
    @GetMapping({"/querybyname"})
    GisNode queryByName(@RequestParam(name = "name") String name);

    /**
     * 添加新节点
     *
     * @param node
     * @return
     */
    @PostMapping({"/add"})
    ResultBean add(@RequestBody GisNode node);

    /**
     * 更新节点信息
     *
     * @param node
     * @return
     */
    @PostMapping({"/update"})
    ResultBean update(@RequestBody GisNode node);

    /**
     * 删除指定节点
     *
     * @param id
     * @return
     */
    @GetMapping({"/delete"})
    ResultBean delete(@RequestParam(name = "id") String id);

    /**
     * 获取服务列表
     *
     * @param id
     * @return
     */
    @GetMapping({"/services"})
    public ArcgisServicesResponse services(@RequestParam(name = "id") String id, @RequestParam(name = "folder", required = false, defaultValue = "") String folder);

    /**
     * 获取服务信息
     *
     * @param id
     * @return
     */
    @GetMapping({"/service"})
    public ArcgisServiceDetailResponse service(@RequestParam(name = "id") String id, @RequestParam(name = "folder", required = false, defaultValue = "") String folder, @RequestParam(name = "serviceName") String serviceName, @RequestParam(name = "serviceType") String serviceType);
}
