/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.gis.utils;

import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;

public final class UUIDGenerator {
    private static final AtomicInteger counter;
    private static final int JVM;
    private static final int IP;

    private UUIDGenerator() {
    }

    private static int toInt(byte[] bytes) {
        int result = 0;
        int count = 4;
        for (int i = 0; i < count; ++i) {
            result = (result << 8) - 128 + bytes[i];
        }
        return result;
    }

    private static short getCount() {
        counter.compareAndSet(Short.MAX_VALUE, 0);
        return (short)counter.incrementAndGet();
    }

    private static String format(int intValue) {
        return StringUtils.leftPad((String)Integer.toHexString(intValue), (int)8, (String)"0");
    }

    private static String format(short shortValue) {
        return StringUtils.leftPad((String)Integer.toHexString(shortValue), (int)4, (String)"0");
    }

    public static String generate() {
        long now = System.currentTimeMillis();
        short hiTime = (short)(now >>> 32);
        int loTime = (int)now;
        StringBuilder sb = new StringBuilder(32).append(UUIDGenerator.format(hiTime)).append(UUIDGenerator.format(loTime)).append(UUIDGenerator.format(IP)).append(UUIDGenerator.format(JVM)).append(UUIDGenerator.format(UUIDGenerator.getCount()));
        sb.setCharAt(0, 'f');
        return sb.toString();
    }

    static {
        int ipadd;
        counter = new AtomicInteger(0);
        JVM = (int)(System.currentTimeMillis() >>> 8);
        try {
            ipadd = UUIDGenerator.toInt(InetAddress.getLocalHost().getAddress());
        }
        catch (Exception e) {
            ipadd = 0;
        }
        IP = ipadd;
    }
}

