/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.gis.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    private static DecimalFormat df = new DecimalFormat("0");
    private static DecimalFormat nf = new DecimalFormat("0.00");

    private ExcelUtil() {
    }

    public static ArrayList<ArrayList<Object>> readExcel(File file) {
        if (file == null) {
            return new ArrayList<ArrayList<Object>>(0);
        }
        if (file.getName().endsWith("xlsx")) {
            return ExcelUtil.readExcel2007(file);
        }
        return ExcelUtil.readExcel2003(file);
    }

    public static ArrayList<ArrayList<Object>> readExcel2003(File file) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        try {
            ArrayList<ArrayList<Object>> rowList = new ArrayList<ArrayList<Object>>();
            HSSFWorkbook wb = new HSSFWorkbook((InputStream)new FileInputStream(file));
            HSSFSheet sheet = wb.getSheetAt(0);
            int i = sheet.getFirstRowNum();
            int rowCount = 0;
            while (rowCount < sheet.getPhysicalNumberOfRows()) {
                HSSFRow row = sheet.getRow(i);
                ArrayList<Object> colList = new ArrayList<Object>();
                if (row == null) {
                    if (i != sheet.getPhysicalNumberOfRows()) {
                        rowList.add(colList);
                    }
                } else {
                    ++rowCount;
                    for (int j = row.getFirstCellNum(); j <= row.getLastCellNum(); ++j) {
                        Object value;
                        HSSFCell cell = row.getCell(j);
                        if (cell == null || cell.getCellType() == 3) {
                            if (j == row.getLastCellNum()) continue;
                            colList.add("");
                            continue;
                        }
                        switch (cell.getCellType()) {
                            case 1: {
                                value = cell.getStringCellValue();
                                break;
                            }
                            case 0: {
                                if ("@".equals(cell.getCellStyle().getDataFormatString())) {
                                    value = df.format(cell.getNumericCellValue());
                                    break;
                                }
                                if ("General".equals(cell.getCellStyle().getDataFormatString())) {
                                    value = nf.format(cell.getNumericCellValue());
                                    break;
                                }
                                value = sdf.format(HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()));
                                break;
                            }
                            case 4: {
                                value = cell.getBooleanCellValue();
                                break;
                            }
                            case 3: {
                                value = "";
                                break;
                            }
                            default: {
                                value = cell.toString();
                            }
                        }
                        colList.add(value);
                    }
                    rowList.add(colList);
                }
                ++i;
            }
            return rowList;
        }
        catch (Exception e) {
            return new ArrayList<ArrayList<Object>>(0);
        }
    }

    public static ArrayList<ArrayList<Object>> readExcel2007(File file) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        try {
            ArrayList<ArrayList<Object>> rowList = new ArrayList<ArrayList<Object>>();
            XSSFWorkbook wb = new XSSFWorkbook((InputStream)new FileInputStream(file));
            XSSFSheet sheet = wb.getSheetAt(0);
            int i = sheet.getFirstRowNum();
            int rowCount = 0;
            while (rowCount < sheet.getPhysicalNumberOfRows()) {
                XSSFRow row = sheet.getRow(i);
                ArrayList<Object> colList = new ArrayList<Object>();
                if (row == null) {
                    if (i != sheet.getPhysicalNumberOfRows()) {
                        rowList.add(colList);
                    }
                } else {
                    ++rowCount;
                    for (int j = row.getFirstCellNum(); j <= row.getLastCellNum(); ++j) {
                        Object value;
                        XSSFCell cell = row.getCell(j);
                        if (cell == null || cell.getCellType() == 3) {
                            if (j == row.getLastCellNum()) continue;
                            colList.add("");
                            continue;
                        }
                        switch (cell.getCellType()) {
                            case 1: {
                                value = cell.getStringCellValue();
                                break;
                            }
                            case 0: {
                                if ("@".equals(cell.getCellStyle().getDataFormatString())) {
                                    value = df.format(cell.getNumericCellValue());
                                    break;
                                }
                                if ("General".equals(cell.getCellStyle().getDataFormatString())) {
                                    value = nf.format(cell.getNumericCellValue());
                                    break;
                                }
                                value = sdf.format(HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()));
                                break;
                            }
                            case 4: {
                                value = cell.getBooleanCellValue();
                                break;
                            }
                            case 3: {
                                value = "";
                                break;
                            }
                            default: {
                                value = cell.toString();
                            }
                        }
                        colList.add(value);
                    }
                    rowList.add(colList);
                }
                ++i;
            }
            return rowList;
        }
        catch (Exception e) {
            return new ArrayList<ArrayList<Object>>(0);
        }
    }

    public static void writeExcel(ArrayList<ArrayList<Object>> result, String path) {
        if (result == null) {
            return;
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("sheet1");
        for (int i = 0; i < result.size(); ++i) {
            HSSFRow row = sheet.createRow(i);
            if (result.get(i) == null) continue;
            for (int j = 0; j < result.get(i).size(); ++j) {
                HSSFCell cell = row.createCell(j);
                cell.setCellValue(result.get(i).get(j).toString());
            }
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] content = os.toByteArray();
        File file = new File(path);
        try (FileOutputStream fos = new FileOutputStream(file);){
            ((OutputStream)fos).write(content);
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DecimalFormat getDf() {
        return df;
    }

    public static void setDf(DecimalFormat df) {
        ExcelUtil.df = df;
    }

    public static DecimalFormat getNf() {
        return nf;
    }

    public static void setNf(DecimalFormat nf) {
        ExcelUtil.nf = nf;
    }
}

