/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.gis.support.http;

import cn.gtmap.gtc.gis.support.http.FormFieldKeyValuePair;
import cn.gtmap.gtc.gis.support.http.MultiPartFileItem;
import cn.gtmap.gtc.gis.support.http.MultiPartRequestEmulator;
import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class HttpRequest {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequest.class);
    private static final int DEFAULT_TIME_OUT = 300000;
    private static String zhPattern = "[\\u4e00-\\u9fa5]+";
    public static final String UTF_8 = "utf-8";

    public static final Object get(String url, String queryString, String dataType) {
        if (StringUtils.isBlank((String)url)) {
            throw new RuntimeException("request url is null");
        }
        queryString = queryString.replace("#", "%23");
        HttpClient http = new HttpClient();
        GetMethod get = new GetMethod(url);
        if (StringUtils.isNotBlank((String)queryString)) {
            get.setQueryString(queryString);
        }
        return HttpRequest.request(http, (HttpMethod)get, dataType);
    }

    public static final Object post(String url, NameValuePair[] data, String dataType) {
        if (StringUtils.isBlank((String)url)) {
            throw new RuntimeException("request url is null");
        }
        HttpClient http = new HttpClient();
        PostMethod post = new PostMethod(url);
        if (data != null && data.length > 0) {
            post.addParameters(data);
        }
        return HttpRequest.request(http, (HttpMethod)post, dataType);
    }

    public static final String postAsForm(String url, NameValuePair[] data) {
        if (StringUtils.isBlank((String)url)) {
            throw new RuntimeException("request url is null");
        }
        Assert.notNull((Object)data, (String)"Data cannot be null!");
        HttpClient http = new HttpClient();
        PostMethod postMethod = new PostMethod(url);
        if (data != null && data.length > 0) {
            postMethod.setRequestBody(data);
        }
        return (String)HttpRequest.request(http, (HttpMethod)postMethod, RES_DATA_TYPE.text.name());
    }

    public static Object post(String url, Map data, String dataType) {
        if (StringUtils.isBlank((String)url)) {
            throw new RuntimeException("request url is null");
        }
        String https = "https";
        if (StringUtils.startsWith((String)url, (String)https)) {
            if (RES_DATA_TYPE.json.name().equalsIgnoreCase(dataType)) {
                return HttpRequest.sendHttpsJSON(url, data);
            }
            return HttpRequest.sendHttps(url, data);
        }
        try {
            HttpClient http = new HttpClient();
            PostMethod postMethod = new PostMethod(HttpRequest.encode(url, UTF_8));
            if (data != null && !data.isEmpty()) {
                for (Map.Entry item : data.entrySet()) {
                    Map.Entry entry = item;
                    Object value = entry.getValue();
                    if (value instanceof byte[]) {
                        postMethod.addParameter(String.valueOf(entry.getKey()), IOUtils.toString((byte[])((byte[])value), (String)UTF_8));
                        continue;
                    }
                    postMethod.addParameter(String.valueOf(entry.getKey()), value instanceof String[] ? ((String[])entry.getValue())[0] : String.valueOf(value));
                }
            }
            return HttpRequest.request(http, (HttpMethod)postMethod, dataType);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("http post error: {}", (Object)e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (Exception e) {
            logger.error("http post error: {}", (Object)e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public static String sendHttps(String url, Map data) {
        try {
            MultiPartRequestEmulator.trustAllHttpsCertificates();
            HttpsURLConnection.setDefaultHostnameVerifier((urlHostName, session) -> true);
            String boundary = "----------HV2ymHFg03ehbqgZCaKO6jyH";
            URL serverUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)serverUrl.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Connection", "Keep-Alive");
            connection.setRequestProperty("Charset", UTF_8);
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            StringBuffer contentBody = new StringBuffer("--" + boundary);
            String endBoundary = "\r\n--" + boundary + "--\r\n";
            OutputStream out = connection.getOutputStream();
            for (Object k : data.keySet()) {
                Object value = data.get(k);
                contentBody.append("\r\n").append("Content-Disposition: form-data; name=\"").append(String.valueOf(k) + "\"").append("\r\n").append("\r\n").append(value instanceof String[] ? ((String[])value)[0] : value.toString()).append("\r\n").append("--").append(boundary);
            }
            String boundaryMessage = contentBody.toString();
            out.write(boundaryMessage.getBytes(UTF_8));
            out.write(boundary.concat("\r\n").getBytes(UTF_8));
            out.write(endBoundary.getBytes(UTF_8));
            out.flush();
            out.close();
            InputStream in = connection.getInputStream();
            return IOUtils.toString((InputStream)in, (String)UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public static Map sendHttpsJSON(String url, Map data) {
        String ret = HttpRequest.sendHttps(url, data);
        return (Map)JSON.parseObject((String)ret, Map.class);
    }

    public static Object multiPartRequest(String url, Map data, File file) {
        FileInputStream fileInputStream = null;
        try {
            String response;
            ArrayList<FormFieldKeyValuePair> ffkvp = new ArrayList<FormFieldKeyValuePair>();
            Iterator iterator = data.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry obj;
                Map.Entry entry = obj = iterator.next();
                Object key = entry.getKey();
                Object val = entry.getValue();
                if (!(key instanceof String)) continue;
                ffkvp.add(new FormFieldKeyValuePair(String.valueOf(key), val instanceof String[] ? ((String[])entry.getValue())[0] : val.toString()));
            }
            ArrayList<MultiPartFileItem> mfi = new ArrayList<MultiPartFileItem>(1);
            if (file != null) {
                fileInputStream = new FileInputStream(file);
                mfi.add(new MultiPartFileItem("file", file.getName(), IOUtils.toByteArray((InputStream)fileInputStream)));
            }
            MultiPartRequestEmulator mre = new MultiPartRequestEmulator();
            String string = response = MultiPartRequestEmulator.sendPostRequest(url, ffkvp, mfi);
            return string;
        }
        catch (Exception e) {
            logger.error("MultiPartRequest \u8bf7\u6c42\u5f02\u5e38\uff1a {}", (Object)e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception ex) {
                logger.error(ex.getLocalizedMessage());
            }
        }
    }

    public static final String sendRequest(String urlString, String postString) throws Exception {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Content-Type", UTF_8);
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            connection.setConnectTimeout(300000);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            byte[] postByte = new byte[1];
            int postLength = 0;
            if (StringUtils.isNotBlank((String)postString)) {
                postByte = postString.getBytes(UTF_8);
                postLength = postByte.length;
            }
            connection.getOutputStream().write(postByte, 0, postLength);
            connection.getOutputStream().flush();
            connection.getOutputStream().close();
            if (connection.getResponseCode() == 200) {
                String string = HttpRequest.getStringFromInputStream(connection.getInputStream(), UTF_8);
                return string;
            }
            try {
                String statusMsg = "{" + connection.getResponseCode() + " - " + connection.getResponseMessage() + "}";
                throw new Exception("Http\u8bf7\u6c42\u5f02\u5e38\uff1a" + statusMsg);
            }
            catch (Exception e) {
                throw new Exception("Http\u8bf7\u6c42\u5f02\u5e38\uff1a" + e.getLocalizedMessage());
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static final String getStringFromInputStream(InputStream is, String encode) {
        try {
            InputStreamReader isr = new InputStreamReader(is, encode != null ? encode : UTF_8);
            StringBuffer sb = new StringBuffer("");
            BufferedReader br = new BufferedReader(isr);
            String str = br.readLine();
            while (str != null) {
                sb.append(str);
                str = br.readLine();
            }
            return sb.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String sendRequest2(String urlString, String postString) throws Exception {
        String result;
        HttpClient http = new HttpClient();
        GetMethod method = new GetMethod(urlString);
        method.setRequestHeader("Content-Type", UTF_8);
        if (StringUtils.isNotBlank((String)postString)) {
            method.setQueryString(postString);
        }
        try {
            int status = http.executeMethod((HttpMethod)method);
            result = IOUtils.toString((InputStream)method.getResponseBodyAsStream(), (String)UTF_8);
            if (200 == status) {
                String string = result;
                return string;
            }
        }
        catch (Exception e) {
            result = e.getLocalizedMessage();
        }
        finally {
            method.releaseConnection();
        }
        throw new Exception("Http\u8bf7\u6c42\u5f02\u5e38\uff1a" + result);
    }

    public static String encode(String str, String charset) throws UnsupportedEncodingException {
        str = str.replaceAll(" ", "+");
        Pattern p = Pattern.compile(zhPattern);
        Matcher m = p.matcher(str);
        StringBuffer b = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(b, URLEncoder.encode(m.group(0), charset));
        }
        m.appendTail(b);
        return b.toString();
    }

    public static final Map parseUriParams(String uri) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String paramStr;
            String[] strs;
            if (StringUtils.isNotBlank((String)uri) && (strs = uri.split("\\?")).length > 1 && StringUtils.isNotBlank((String)(paramStr = strs[1]))) {
                String[] params = paramStr.split("&");
                for (int i = 0; i < params.length; ++i) {
                    String param = params[i];
                    if (!StringUtils.isNotBlank((String)param) || !StringUtils.contains((String)param, (String)"=")) continue;
                    String[] tmp = param.split("=");
                    map.put(tmp[0], tmp[1]);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("parse uri params exception{}", e);
        }
        return map;
    }

    public static final Map parseParam(String uri, Map parameterMap) throws Exception {
        HashMap map = new HashMap();
        Map uriParam = HttpRequest.parseUriParams(uri);
        if (!uriParam.isEmpty()) {
            map.putAll(uriParam);
        }
        if (!parameterMap.isEmpty()) {
            for (Object key : parameterMap.keySet()) {
                Pattern pattern = Pattern.compile("^http\\:\\/\\/.+$");
                Matcher matcher = pattern.matcher((String)key);
                if (matcher.matches() || "requestUrl".equalsIgnoreCase(String.valueOf(key)) || "dateType".equalsIgnoreCase(String.valueOf(key))) continue;
                map.put(key, parameterMap.get(key));
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object request(HttpClient http, HttpMethod method, String dataType) {
        String result;
        method.getParams().setSoTimeout(300000);
        method.getParams().setContentCharset(UTF_8);
        method.getParams().setUriCharset(UTF_8);
        method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        try {
            int status = http.executeMethod(method);
            byte[] bytes = method.getResponseBody();
            result = IOUtils.toString((byte[])bytes, (String)UTF_8);
            if (200 == status) {
                block16: {
                    try {
                        if (!StringUtils.isBlank((String)dataType)) break block16;
                        String string = result;
                        return string;
                    }
                    catch (IllegalArgumentException e) {
                        String string = result;
                        return string;
                    }
                }
                switch (RES_DATA_TYPE.valueOf(dataType)) {
                    case json: {
                        Object object = JSON.parse((String)result);
                        return object;
                    }
                    case bytes: {
                        byte[] byArray = bytes;
                        return byArray;
                    }
                }
                String string = result;
                return string;
            }
            method.releaseConnection();
        }
        catch (Exception e) {
            result = e.getLocalizedMessage();
        }
        finally {
            method.releaseConnection();
        }
        throw new RuntimeException("\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38: [" + result + "]");
    }

    public static final byte[] get(String url, String queryString, boolean removeAcceptEncoding) {
        if (StringUtils.isBlank((String)url)) {
            throw new RuntimeException("request url is null");
        }
        HttpClient http = new HttpClient();
        GetMethod get = new GetMethod(url);
        if (StringUtils.isNotBlank((String)queryString)) {
            get.setQueryString(queryString);
        }
        return HttpRequest.request(http, (HttpMethod)get, removeAcceptEncoding);
    }

    public static byte[] request(HttpClient http, HttpMethod method, boolean removeAcceptEncoding) {
        String ret = null;
        method.getParams().setSoTimeout(300000);
        method.getParams().setContentCharset(UTF_8);
        method.getParams().setUriCharset(UTF_8);
        if (removeAcceptEncoding) {
            method.removeRequestHeader("Accept-Encoding");
        }
        try {
            int status = http.executeMethod(method);
            byte[] bytes = method.getResponseBody();
            if (200 == status) {
                byte[] byArray = bytes;
                return byArray;
            }
        }
        catch (Exception e) {
            ret = e.getLocalizedMessage();
            throw new RuntimeException("\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38: [" + ret + "]");
        }
        finally {
            method.releaseConnection();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static final String postJson(String url, String json) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static enum RES_DATA_TYPE {
        text,
        json,
        bytes;

    }
}

