/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.gis.support.hibernate.type.json.internal;

import cn.gtmap.gtc.gis.support.hibernate.type.json.internal.JacksonUtil;
import com.fasterxml.jackson.databind.JsonNode;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;

public class JsonNodeTypeDescriptor
extends AbstractTypeDescriptor<JsonNode> {
    public static final JsonNodeTypeDescriptor INSTANCE = new JsonNodeTypeDescriptor();

    public JsonNodeTypeDescriptor() {
        super(JsonNode.class, (MutabilityPlan)new MutableMutabilityPlan<JsonNode>(){

            protected JsonNode deepCopyNotNull(JsonNode value) {
                return JacksonUtil.clone(value);
            }
        });
    }

    public boolean areEqual(JsonNode one, JsonNode another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return JacksonUtil.toJsonNode(JacksonUtil.toString(one)).equals((Object)JacksonUtil.toJsonNode(JacksonUtil.toString(another)));
    }

    public String toString(JsonNode value) {
        return JacksonUtil.toString(value);
    }

    public JsonNode fromString(String string) {
        return JacksonUtil.toJsonNode(string);
    }

    public <X> X unwrap(JsonNode value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        if (JsonNode.class.isAssignableFrom(type)) {
            return (X)JacksonUtil.toJsonNode(this.toString(value));
        }
        throw this.unknownUnwrap(type);
    }

    public <X> JsonNode wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        return this.fromString(value.toString());
    }
}

