/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.gis.support;

import cn.gtmap.gtc.gis.support.Document;
import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;

public class BaseController {
    protected static final String RES = "result";
    protected static final String REQUEST_FILE_NOT_FOUND = "request file not found";
    protected static final String LAST_MODIFIED = "Last-Modified";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected void sendFile(File file, HttpServletResponse response) throws IOException {
        if (file == null || response == null) {
            return;
        }
        if (file.exists()) {
            response.setDateHeader(LAST_MODIFIED, file.lastModified());
            response.setContentLength((int)file.length());
            try (FileInputStream stream = new FileInputStream(file);){
                FileCopyUtils.copy((InputStream)stream, (OutputStream)response.getOutputStream());
            }
            catch (IOException e) {
                this.logger.error(e.toString());
            }
        } else {
            response.sendError(404, REQUEST_FILE_NOT_FOUND);
        }
    }

    protected void sendFile(InputStream inputStream, HttpServletResponse response, String fileName) throws IOException {
        if (inputStream == null || response == null) {
            return;
        }
        if (inputStream.available() > 0) {
            response.addHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.setDateHeader(LAST_MODIFIED, System.currentTimeMillis());
            response.setContentLength(inputStream.available());
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        } else {
            response.sendError(404, REQUEST_FILE_NOT_FOUND);
        }
    }

    protected void sendDocument(HttpServletResponse response, Document document) throws IOException {
        this.sendStream(new ByteArrayInputStream(document.getContent()), response, document.getFileName());
    }

    protected void sendStream(InputStream inputStream, HttpServletResponse response, String fileName) throws IOException {
        if (inputStream == null || response == null) {
            return;
        }
        if (inputStream.available() > 0) {
            response.addHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "utf-8"));
            response.setDateHeader(LAST_MODIFIED, System.currentTimeMillis());
            response.setContentLength(inputStream.available());
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        } else {
            response.sendError(404, REQUEST_FILE_NOT_FOUND);
        }
    }

    protected Map<String, Object> result(Object value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(RES, value);
        return result;
    }

    protected Map<String, Object> fail(Object value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", false);
        result.put("msg", value);
        return result;
    }

    protected void error(String info, HttpServletResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", false);
        result.put("msg", info);
        try {
            response.getWriter().write(JSON.toJSONString(result));
        }
        catch (IOException e) {
            this.logger.error(e.getLocalizedMessage());
        }
    }

    protected void result(Object value, HttpServletResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(RES, value);
        try {
            response.getWriter().write(JSON.toJSONString(result));
        }
        catch (IOException e) {
            this.logger.error(e.getLocalizedMessage());
        }
    }
}

