/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.gis.clients.data.featureservice;

import java.util.Map;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="${app.services.gis-featureService:gis-featureService}")
@RequestMapping(value={"/featureService"})
public interface FeatureServiceClient {
    @GetMapping(value={"/urls"})
    public Map getUrls();

    @GetMapping(value={"/layerCrs"})
    public Map getLayerCRS(@RequestParam(name="layerName") String var1, @RequestParam(name="dataSource") String var2);

    @PostMapping(value={"/queryByAttr"})
    public Map query(@RequestParam(name="layerName") String var1, @RequestParam(name="where") String var2, @RequestParam(name="columns", required=false) String[] var3, @RequestParam(name="returnGeometry", defaultValue="true") boolean var4, @RequestParam(name="dataSource") String var5);

    @PostMapping(value={"/queryBySpatial"})
    public Map query(@RequestBody Map var1);

    @PostMapping(value={"/queryByAttrAndSpatial"})
    public Map query(@RequestParam(name="layerName") String var1, @RequestParam(name="wkt") String var2, @RequestParam(name="where") String var3, @RequestParam(name="columns", required=false) String[] var4, @RequestParam(name="dataSource") String var5, @RequestParam(name="filterMethod") int var6);

    @GetMapping(value={"/layerColumns"})
    public Map getLayerColumns(@RequestParam(name="layerName") String var1, @RequestParam(name="dataSource") String var2);

    @PostMapping(value={"/insert"})
    public Map insert(@RequestParam(name="layerName") String var1, @RequestParam(name="columns") String var2, @RequestParam(name="dataSource") String var3);

    @PostMapping(value={"/update"})
    public Map update(@RequestParam(name="layerName") String var1, @RequestParam(name="primaryKey") String var2, @RequestParam(name="columns") String var3, @RequestParam(name="dataSource") String var4);

    @PostMapping(value={"/delete"})
    public Map delete(@RequestParam(name="layerName") String var1, @RequestParam(name="primaryKey") String var2, @RequestParam(name="dataSource") String var3);

    @PostMapping(value={"/deleteByWhere"})
    public Map deleteByWhere(@RequestParam(name="layerName") String var1, @RequestParam(name="where") String var2, @RequestParam(name="dataSource") String var3);

    @GetMapping(value={"/layerColumnsType"})
    public Map getLayerColumnsType(@RequestParam(name="layerName") String var1, @RequestParam(name="dataSource") String var2);

    @GetMapping(value={"/checkLayer"})
    public Map checkLayer(@RequestParam(name="user") String var1, @RequestParam(name="layerName") String var2);

    @GetMapping(value={"/attStates"})
    public Map getQueryTableStats(@RequestParam(value="layerName") String var1, @RequestParam(value="where", required=false) String var2, @RequestParam(value="dataSource") String var3);
}

