package cn.gtmap.gtc.gis.domain.sde;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author <a href="mailto:shanhuashuiqing11@163.com">zhangsongshan</a>
 * @version V1.0, 2019/6/18 10:54
 * @Description:
 */
@Data
public class PageBean<T> implements Serializable {

    /**
     * 每页显记录的条数
     */
    private Integer pageSize;

    /**
     * 当前页
     */
    private Integer currentPage;

    /**
     * 总页数
     */
    private Integer totalPage;

    /**
     * 总记录数
     */
    private Integer totalRecord;

    /**
     * 要显示的数据
     */
    private List<T> dataList;

    public PageBean() {
    }

    /**
     * 逻辑分页
     *
     * @param pageNum    当前页
     * @param pageSize   当前页显示的记录条数数
     * @param sourceList 所有数据集合
     */
    public PageBean(Integer pageNum, Integer pageSize, List<T> sourceList) {
        //总记录数
        this.totalRecord = sourceList.size();
        //每页显示的记录条数
        this.pageSize = pageSize;
        //总页数
        this.totalPage = (this.totalRecord + this.pageSize - 1) / this.pageSize;
        //当前页小于1则当前页等于1
        pageNum = pageNum >= 1 ? pageNum : 1;
        //当前页
        this.currentPage = pageNum >= totalPage ? totalPage : pageNum;

        //起始索引
        Integer fromIndex = (this.currentPage - 1) * this.pageSize;
        //结束索引
        Integer toIndex = this.pageSize * this.currentPage >= this.totalRecord ? this.totalRecord : this.pageSize * this.currentPage;
        //当前页显示的记录
        this.dataList = sourceList.subList(fromIndex, toIndex);
    }

    /**
     * 通过构造函数生成一个Pager对象
     *
     * @param currentPage 当前页
     * @param pageSize    当前页显示的记录条数
     * @param totalRecord 总记录数
     * @param dataList    当前页要显示的数据
     */
    public PageBean(Integer currentPage, Integer pageSize, Integer totalRecord, List<T> dataList) {
        this.pageSize = pageSize;
        this.currentPage = currentPage;
        this.totalPage = (totalRecord + pageSize - 1) / pageSize;
        this.totalRecord = totalRecord;
        this.dataList = dataList;
    }

}
