package cn.gtmap.gtc.gis.clients.data.search;

import cn.gtmap.gtc.gis.domain.esm.Feature;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * Created by Fjj on 2017/11/21.
 * elasticsearch中图层的属性查询
 */
@FeignClient(name="${app.services.gis-search:gis-search}")
@RequestMapping("/es/{name}/query/defined/attribute")
public interface EsAttributeQueryClient {

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @GetMapping({"/byid"})
    Feature queryById(String id, @PathVariable("name") String name);

    /**
     * 精确查询(各查询条件之间是and关系)
     *
     * @param params
     * @param name
     * @return
     */
    @GetMapping({"/exact"})
    Page<Feature> exactQuery(@RequestParam Map<String, String> params, @PathVariable("name") String name);

    /**
     * like查询(各查询条件间and关系)
     *
     * @param params
     * @param name
     * @return
     */
    @GetMapping({"/andlike"})
    Page<Feature> andLikeQuery(@RequestParam Map<String, String> params, @PathVariable("name") String name);


    /**
     * like查询(各查询条件间or关系)
     *
     * @param params
     * @param name
     * @return
     */
    @GetMapping({"/orlike"})
    Page<Feature> orLikeQuery(@RequestParam Map<String, String> params, @PathVariable("name") String name);

    /**
     * match查询(各查询条件间or关系)
     *
     * @param params
     * @param name
     * @return
     */
    @GetMapping({"/match"})
    Page<Feature> matchQuery(@RequestParam Map<String, String> params, @PathVariable("name") String name);

    /**
     * match_phrase查询(各查询条件间or关系)
     *
     * @param params
     * @param name
     * @return
     */
    @GetMapping({"/matchPhraseOr"})
    public Page<Feature> matchPhraseOrQuery(@RequestParam Map<String, String> params, @PathVariable("name") String name);

    /**
     * match_phrase查询(各查询条件间and关系)
     *
     * @param params
     * @param name
     * @return
     */
    @GetMapping({"/matchPhraseAnd"})
    public Page<Feature> matchPhraseAndQuery(@RequestParam Map<String, String> params, @PathVariable("name") String name);

    /**
     * match查询(各查询条件间or关系)
     *
     * @param key
     * @param values
     * @param name
     * @return
     */
    @GetMapping({"/in"})
    public List<Feature> inQuery(@RequestParam(name = "key") String key, @RequestParam(name = "values[]") String[] values, @PathVariable("name") String name);
}
