package cn.gtmap.gtc.gis.clients.data.featureservice;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author shanhuashuiqing11@163.com
 * @version v1.0 2018/10/17 15:42
 */
@FeignClient(name="${app.services.gis-featureService:gis-featureService}")
@RequestMapping("/featureService")
public interface FeatureServiceClient {
    /**
     * 获取数据源、图层信息
     *
     * @return
     */
    @GetMapping("/urls")
    Map getUrls();

    /**
     * 获取图层坐标系信息
     *
     * @param layerName
     * @param dataSource
     * @return
     */
    @GetMapping("/layerCrs")
    Map getLayerCRS(@RequestParam(name = "layerName") String layerName,
                    @RequestParam(name = "dataSource") String dataSource);

    /**
     * 属性查询
     *
     * @param layerName
     * @param where
     * @param columns
     * @param returnGeometry
     * @param dataSource
     * @return
     */
    @PostMapping("/queryByAttr")
    Map query(@RequestParam(name = "layerName") String layerName,
              @RequestParam(name = "where") String where,
              @RequestParam(name = "columns", required = false) String[] columns,
              @RequestParam(name = "returnGeometry", defaultValue = "true") boolean returnGeometry,
              @RequestParam(name = "dataSource") String dataSource);

    /**
     * 空间查询
     * layerName wkt columns dataSource filterMethod
     *
     * @param params
     * @return
     */
    @PostMapping("/queryBySpatial")
    Map query(@RequestBody Map params);


    /**
     * 空间属性联合查询
     *
     * @param layerName
     * @param wkt
     * @param where
     * @param columns
     * @param dataSource
     * @param filterMethod
     * @return
     */
    @PostMapping("/queryByAttrAndSpatial")
    Map query(@RequestParam(name = "layerName") String layerName,
              @RequestParam(name = "wkt") String wkt,
              @RequestParam(name = "where") String where,
              @RequestParam(name = "columns", required = false) String[] columns,
              @RequestParam(name = "dataSource") String dataSource,
              @RequestParam(name = "filterMethod") int filterMethod);

    /**
     * 获取图层字段
     *
     * @param layerName
     * @param dataSource
     * @return
     */
    @GetMapping("/layerColumns")
    Map getLayerColumns(@RequestParam(name = "layerName") String layerName,
                        @RequestParam(name = "dataSource") String dataSource);

    /**
     * 插入要素
     *
     * @param layerName
     * @param columns    json
     * @param dataSource
     * @return
     */
    @PostMapping("/insert")
    Map insert(@RequestParam(name = "layerName") String layerName,
               @RequestParam(name = "columns") String columns,
               @RequestParam(name = "dataSource") String dataSource);


    /**
     * 更新要素
     *
     * @param layerName
     * @param primaryKey
     * @param columns    json
     * @param dataSource
     * @return
     */
    @PostMapping("/update")
    Map update(@RequestParam(name = "layerName") String layerName,
               @RequestParam(name = "primaryKey") String primaryKey,
               @RequestParam(name = "columns") String columns,
               @RequestParam(name = "dataSource") String dataSource);


    /**
     * 删除要素
     *
     * @param layerName
     * @param primaryKey
     * @param dataSource
     * @return
     */
    @PostMapping("/delete")
    Map delete(@RequestParam(name = "layerName") String layerName,
               @RequestParam(name = "primaryKey") String primaryKey,
               @RequestParam(name = "dataSource") String dataSource);

    /**
     * 根据条件删除要素
     *
     * @param layerName
     * @param where
     * @param dataSource
     * @return
     */
    @PostMapping("/deleteByWhere")
    Map deleteByWhere(@RequestParam(name = "layerName") String layerName,
                      @RequestParam(name = "where") String where,
                      @RequestParam(name = "dataSource") String dataSource);


    /**
     * 获取字段类型信息
     *
     * @param layerName
     * @param dataSource
     * @return
     */
    @GetMapping("/layerColumnsType")
    Map getLayerColumnsType(@RequestParam(name = "layerName") String layerName,
                            @RequestParam(name = "dataSource") String dataSource);


    /**
     * 检查图层是否存在
     *
     * @param user
     * @param layerName
     * @return
     */
    @GetMapping("/checkLayer")
    Map checkLayer(@RequestParam(name = "user") String user,
                   @RequestParam(name = "layerName") String layerName);

    /**
     * 获取图层查询结果的统计信息
     * 返回值包含：count(总数)、max和min(ObjectId的最大值和最小值)
     *
     * @param layerName
     * @param where
     * @param dataSource
     * @return
     */
    @GetMapping("/attStates")
    Map getQueryTableStats(@RequestParam(value = "layerName") String layerName,
                           @RequestParam(value = "where", required = false) String where,
                           @RequestParam(value = "dataSource") String dataSource);
}
