package cn.gtmap.gtc.gis.clients.analysis;

import cn.gtmap.gtc.gis.domain.data.analysis.BMarkGeometry;
import cn.gtmap.gtc.gis.domain.data.analysis.DocumentTransfer;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * .GISMiscClient
 *
 * @author <a href="mailto:yingxiufeng@gtmap.cn">alex.y</a>
 * @version v1.0, 2018/5/7 (c) Copyright gtmap Corp.
 */
@FeignClient(name="${app.services.gis-data-analysis:gis-data-analysis}")
@RequestMapping("/gis/misc")
public interface GISMiscClient {

    /***
     * 拓扑检查
     * @param geometry
     * @return
     */
    @PostMapping(value = "/geoCheck")
    String geoTopoCheck(@RequestBody String geometry);

    /***
     * 获取图形面积
     * @param geometry
     * @param crs
     * @return
     */
    @PostMapping(value = "/geoArea")
    double geoArea(@RequestBody String geometry,
                   @RequestParam(value = "crs", defaultValue = "4610") String crs);

    /**
     * 根据参数进行检查，并返回图形拓扑、面积、是否在所属范围内信息
     *
     * @param params geometry , topo check , bound(regionCode) check , get Area
     * @return result(topo Area inbound)
     */
    @PostMapping("/checkGeoJson")
    Map checkGeoJson(@RequestBody Map params);

    /**
     * 导入上传文件
     *
     * @param {"fileBytes":"","fileName":""}
     */
    @PostMapping(value = "/parseGeoFile2")
    String parseGeoFile(@RequestBody Map map);

    /**
     * geojson转为各种文档格式
     *
     * @param geoJson featureCollection
     * @param type    文档类型
     * @param crsType    坐标系   1为地理坐标系   0为投影坐标系
     */
    @PostMapping("/geoJson2AnyFile")
    Map geoJson2AnyFile(@RequestParam(value = "geoJson") String geoJson,
                        @RequestParam(value = "crsType", defaultValue = "0", required = false) String crsType,
                        @RequestParam(value = "type") String type);

    /**
     * 通用excel导出
     *
     * @param data
     * @param tplName
     */
    @PostMapping("/export/excel")
    DocumentTransfer export(@RequestParam("data") String data,
                            @RequestParam(value = "tplName", required = false) String tplName);

    /**
     * 界址点数据插入
     *
     * @param layerName          图层名称
     * @param bMarkGeometriesStr 界址点对象集合Json
     * @param check              是否检查拓扑
     * @param dataSource         数据源
     * @return
     * @throws Exception
     */
    @PostMapping("/bMarkInsert")
    public Map bMarkInsert(@RequestParam(name = "layerName") String layerName,
                           @RequestParam(name = "bMarkGeometries") String bMarkGeometriesStr,
                           @RequestParam(name = "check", defaultValue = "false") boolean check,
                           @RequestParam(name = "dataSource") String dataSource);

    /**
     * 界址点数据更新
     *
     * @param layerName        图层名称
     * @param where            更新数据条件
     * @param bMarkGeometryStr 界址点对象Json
     * @param dataSource       数据源
     * @return
     * @throws Exception
     */
    @PostMapping("/bMarkUpdate")
    public Map bMarkUpdate(@RequestParam(name = "layerName") String layerName,
                           @RequestParam(name = "where") String where,
                           @RequestParam(name = "bMarkGeometry") String bMarkGeometryStr,
                           @RequestParam(name = "dataSource", required = false) String dataSource);

    /**
     * 通用excel导出
     *
     * @param data
     * @param tplName
     */
    @PostMapping("/export/excel/url")
    Map exportExcelUrl(@RequestBody Map content);

    /**
     * 转换界址点对象集合为FeatureCollection
     *
     * @param bMarkGeos
     * @return
     * @throws Exception
     */
    @PostMapping("/bMarksToGeoJSON")
    Map bMarkToGeoJSON(@RequestBody List<BMarkGeometry> bMarkGeos);

    /**
     * 转换界址点对象为Feature
     *
     * @param bMarkGeo
     * @return
     * @throws Exception
     */
    @PostMapping("/bMarkToGeoJSON")
    Map bMarkToGeoJSON(@RequestBody BMarkGeometry bMarkGeo);

}
