package cn.gtmap.gtc.gis.clients.analysis;

import cn.gtmap.gtc.gis.domain.data.analysis.IntersectModel;
import cn.gtmap.gtc.gis.domain.data.analysis.TdghscModel;
import cn.gtmap.gtc.gis.domain.data.analysis.TdlyxzModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.Map;

/**
 * gis 分析 client
 *
 * @author <a href="mailto:yingxiufeng@gtmap.cn">alex.y</a>
 * @version v1.0, 2018/5/4 (c) Copyright gtmap Corp.
 */
@FeignClient(name="${app.services.gis-data-analysis:gis-data-analysis}")
@RequestMapping("/gis/analysis")
public interface GISAnalysisClient {

    /**
     * 规划审查分析
     *
     * @param layerType
     * @param year
     * @param geometry
     * @param outFields
     * @param dataSource
     * @param unit
     * @return
     */
    @RequestMapping(value = "/tdghsc", method = RequestMethod.POST)
    Map tdghscAnalysis(@RequestParam(value = "layerType", defaultValue = "") String layerType,
                       @RequestParam(value = "year", defaultValue = "2020") String year,
                       @RequestParam(value = "geometry") String geometry,
                       @RequestParam(value = "outFields", defaultValue = "*") String outFields,
                       @RequestParam(value = "dataSource", defaultValue = "", required = false) String dataSource,
                       @RequestParam(value = "unit", defaultValue = "SQUARE", required = false) String unit);

    /***
     * 土地利用现状分析
     * @param dltb
     * @param xzdw
     * @param lxdw
     * @param regionCode
     * @param year
     * @param geometry
     * @param dataSource
     * @return
     */
    @RequestMapping(value = "/tdlyxz", method = RequestMethod.POST)
    Map tdlyxzAnalysis(@RequestParam(value = "dltb", required = false) String dltb,
                       @RequestParam(value = "xzdw", required = false) String xzdw,
                       @RequestParam(value = "lxdw", required = false) String lxdw,
                       @RequestParam(value = "regionCode", required = false) String regionCode,
                       @RequestParam(value = "year", required = false) String year,
                       @RequestParam(value = "geometry", required = true) String geometry,
                       @RequestParam(value = "dataSource", defaultValue = "", required = false) String dataSource);

    /***
     * 一般相交分析
     * @param layerName
     * @param geometry
     * @param outFields
     * @param titleField
     * @param fieldAlias
     * @param dataSource
     * @return
     */
    @RequestMapping(value = "/common", method = RequestMethod.POST)
    Map analysis(@RequestParam(value = "layerName") String layerName,
                 @RequestParam(value = "geometry") String geometry,
                 @RequestParam(value = "outFields") String outFields,
                 @RequestParam(value = "titleField") String titleField,
                 @RequestParam(value = "fieldAlias") String fieldAlias,
                 @RequestParam(value = "dataSource", defaultValue = "", required = false) String dataSource);

    /**
     * 地理相交
     *
     * @param layerName
     * @param geometry
     * @param outFields
     * @param dataSource
     * @return
     */
    @PostMapping(value = "/intersect")
    Map intersect(@RequestParam("layerName") String layerName,
                  @RequestParam("geometry") String geometry,
                  @RequestParam(value = "outFields", defaultValue = "*") String outFields,
                  @RequestParam(value = "dataSource", defaultValue = "", required = false) String dataSource);

    /**
     * 关联分析
     * @param layerName  空间数据图层名称
     * @param geometry   GeoJSON 格式图形
     * @param outFields  返回字段
     * @param dataSource 数据源
     * @return
     */
    @PostMapping(value = "/joint")
    Map joint(@RequestParam("layerName") String layerName,
              @RequestParam("geometry") String geometry,
              @RequestParam(value = "outFields", defaultValue = "*") String outFields,
              @RequestParam(value = "dataSource", defaultValue = "", required = false) String dataSource);

    /**
     * difference分析，获取叠加图层中未相交的部分
     * @param layerName
     * @param geometry
     * @param outFields
     * @param dataSource
     * @return
     */
    @PostMapping(value = "/difference")
    Map difference(@RequestParam("layerName") String layerName,
                   @RequestParam("geometry") String geometry,
                   @RequestParam(value = "outFields", defaultValue = "*") String outFields,
                   @RequestParam(value = "dataSource", defaultValue = "", required = false) String dataSource);


    /***
     * 发布 shapefile 的 zip 包到 arcgis ga
     * @param params {file:  base64 编码后的 string,sr}
     * @return
     */
    @RequestMapping(value = "/publishToGa", method = RequestMethod.POST)
    String publishGaLayer(@RequestBody String params);

    /**
     * 土地利用现状分析
     *
     * @param map {"dltb":"","xzdw":"","regionCode":"","year":"","geometry":"","dataSource":""}
     * @return
     */
    @PostMapping(value = "/tdlyxz2")
    Map tdlyxzAnalysis(@RequestBody Map map);

    /**
     * 土地利用现状分析(后台统计结果)
     *
     * @param map {"dltb":"","xzdw":"","regionCode":"","year":"","geometry":"","dataSource":""}
     * @return
     */
    @PostMapping(value = "/tdlyxz3")
    Map tdlyxzAnalysis2(@RequestBody Map map);

    /**
     * 规划审查分析
     *
     * @param map {"layerType":"","year":"","geometry":"","outFields":"","dataSource":"","unit":""}
     * @return
     */
    @RequestMapping(value = "/tdghsc2", method = RequestMethod.POST)
    Map tdghscAnalysis(@RequestBody Map map);

    /**
     * 规划审查分析（汇总统计）
     *
     * @param map {"layerType":"","year":"","geometry":"","outFields":"","dataSource":"","unit":""}
     * @return
     */
    @PostMapping(value = "/tdghsc3")
    Map tdghscAnalysis2(@RequestBody Map map);

    /**
     * 地理相交
     *
     * @param map {"layerName":"","geometry":"","outFields":"","dataSource":""}
     * @return
     */
    @PostMapping(value = "/intersect2")
    Map intersect(@RequestBody Map map);

    /**
     * 关联分析
     *
     * @param map {"layerName":"","geometry":"","outFields":"","dataSource":""}
     * @return
     */
    @PostMapping(value = "/joint2")
    Map joint(@RequestBody Map map);

    /**
     * 通用分析，多图层简单叠加分析
     *
     * @param content
     * @return
     */
    @PostMapping(value = "/multiSimple2")
    Map multiSimple2(@RequestBody String content);

    /**
     * @param tdlyxzModel
     * @return
     * @throws Exception
     */
    @PostMapping("/tdlyxzGa")
    Map gaTdlyxzAnalysis(@RequestBody @Valid TdlyxzModel tdlyxzModel);

    /**
     * ga intersect
     *
     * @param intersectModel
     * @return
     */
    @PostMapping("/intersectGa")
    Map intersectGa(@RequestBody @Valid IntersectModel intersectModel);

    /**
     * ga 土地规划审查
     *
     * @param model
     * @return
     */
    @PostMapping("/tdghscGa")
    Map tdghscGaAnalysis(@RequestBody @Valid TdghscModel model);


    /**
     * 用地情况分析（南通）
     * @return
     */
    @PostMapping("/ydqk")
    Map ydqkAnalysis(@RequestBody String content);

    /**
     * 多图层关联分析
     *
     * @param content
     * @return
     */
    @PostMapping(value = "/multiSimpleJoint")
    Map multiJoint(@RequestBody String content);

    /**
     * 多规控制线检测
     * @param content
     * @return
     */
    @PostMapping("/dgkzxjc")
    Map dgkzxjc(@RequestBody String content);

    /**
     * 生成缓冲区
     * @param geometry
     * @param distance
     * @return
     */
    @PostMapping("/buffer")
    Map buffer(@RequestParam("geometry") String geometry,
               @RequestParam("distance") double distance);
}
