$.views.settings.allowCode(true);
$.views.converters("getResponseModelName", function(val) {
  return getResponseModelName(val);
});

var tempBody = $.templates('#temp_body');
var tempBodyResponseModel = $.templates('#temp_body_response_model');

//获取context path
var contextPath = getContextPath();
function getContextPath() {
  var pathName = document.location.pathname;
  var index = pathName.substr(1).indexOf("/");
  var result = pathName.substr(0,index+1);
  return result;
}

$(function(){
    $.ajax({
        url : "v2/api-docs",
// 	        url : "http://petstore.swagger.io/v2/swagger.json",
        dataType : "json",
        type : "get",
        async : false,
        success : function(data) {
            //layui init
            layui.use([ 'layer','jquery', 'element' ], function() {
	            var $ = layui.jquery, layer = layui.layer, element = layui.element;
	        });
            var jsonData = eval(data);
            var colId = "name"
            var asc = function(x,y)
            {
                return (x[colId] > y[colId]) ? 1 : -1
            }
            jsonData.tags.sort(asc)

            $("#title").html(jsonData.info.title);
            $("body").html($("#template").render(jsonData));
            
            $("[name='a_path']").click(function(){
	            var path = $(this).attr("path");
	            var method = $(this).attr("method");
	            var operationId = $(this).attr("operationId");
	            $.each(jsonData.paths[path],function(i,d){
	              if(d.operationId == operationId){
                      d.path = path;
                      d.method = method;
		              $("#path-body").html(tempBody.render(d));

		              var authUrl = sessionStorage.getItem('auth_url');
                      var username = sessionStorage.getItem('auth-username');
                      var pwd = sessionStorage.getItem('auth-pwd');
                      var clientId = sessionStorage.getItem('auth-client-id');
                      var clientSecret = sessionStorage.getItem('auth-client-secret');
                      $("[name=auth-url]").attr("value",authUrl);
                      $("[name=auth-username]").attr("value",username);
                      $("[name=auth-pwd]").attr("value",pwd);
                      $("[name=auth-client-id]").attr("value",clientId);
                      $("[name=auth-client-secret]").attr("value",clientSecret);

                      var modelName = getResponseModelName(d.responses["200"]["schema"]["$ref"]);
                      if(modelName){
                        $("#path-body-response-model").html(tempBodyResponseModel.render(jsonData.definitions[modelName]));
                      }
	              }
	            });
	        });
	        
	       //提交测试按钮
	       $("[name='btn_submit']").click(function(){
                var operationId = $(this).attr("operationId");
                var parameterJson = {};
                $("input[operationId='"+operationId+"']").each(function(index, domEle){
                    var k = $(domEle).attr("name");
                    var v = $(domEle).val();
                    parameterJson.push({k:v});
                });
            });
        }
    });
    
});


function getResponseModelName(val){
  if(!val){
    return null;
  }
  return val.substring(val.lastIndexOf("/")+1,val.length);
}

function reshToken() {
    var authUrl = $("input[name='auth-url']").val();
    var username = $("input[name='auth-username']").val();
    var pwd = $("input[name='auth-pwd']").val();
    var clientId = $("input[name='auth-client-id']").val();
    var clientSecret = $("input[name='auth-client-secret']").val();

    sessionStorage.setItem('auth_url',authUrl);
    sessionStorage.setItem('auth-username',username);
    sessionStorage.setItem('auth-pwd',pwd);
    sessionStorage.setItem('auth-client-id',clientId);
    sessionStorage.setItem('auth-client-secret',clientSecret);

    var token = getNewAccessToken();
    if (token != "") {
        layer.msg("刷新成功");
    }
}

//测试按钮，获取数据
function getData(operationId){
   var path = contextPath + $("[m_operationId='"+operationId+"']").attr("path");
   //path 参数
   $("[p_operationId='"+operationId+"'][in='path']").each(function(index, domEle){
       var k = $(domEle).attr("name");
       var v = $(domEle).val();
       if(v){
           path = path.replace("{"+k+"}",v);
       }
   });
	
   //header参数
   var headerJson = {};
   $("[p_operationId='"+operationId+"'][in='header']").each(function(index, domEle){
	var k = $(domEle).attr("name");
	var v = $(domEle).val();
	if(v){
	   headerJson[k] = v;
	}
   });
   
   //请求方式
   var parameterType = $("#content_type_"+operationId).val();
   
   //query 参数
   var parameterJson = {};
   if("form" == parameterType){
       $("[p_operationId='"+operationId+"'][in='query']").each(function(index, domEle){
           var k = $(domEle).attr("name");
           var v = $(domEle).val();
           if(v){
               parameterJson[k] = v;
           }
       });
   }else if("json" == parameterType){
       var str = $("#text_tp_"+operationId).val();
       try{
           parameterJson = JSON.parse(str); 
       }catch(error){
           layer.msg(""+error,{icon:5});
           return false;
       }
   }

   var authUrl = sessionStorage.getItem('auth_url');
   if (null == authUrl || authUrl == undefined || authUrl == "") {
       //发送请求
       $.ajax({
           type: $("[m_operationId='"+operationId+"']").attr("method"),
           url: path ,
           headers: headerJson,
           data: parameterJson,
           success: function(data){
               var options = {
                   withQuotes: true
               };
               $("#json-response").jsonViewer(data, options);
           },
           error: function (jqXHR, error, errorThrown) {
               console.log(jqXHR);
               console.log(error);
               console.log(errorThrown);
                var status = jqXHR.status;
                if (status == 401) {
                    layer.msg("无权限访问，查看oauth2是否配置争取！");
                } else {
                    layer.msg("访问失败，查看传参是否正确");
                }
           }
       });
   } else {
       var accessToken = getToken();
       //发送请求
       $.ajax({
           type: $("[m_operationId='"+operationId+"']").attr("method"),
           url: path + "?access_token=" + accessToken,
           headers: headerJson,
           data: parameterJson,
           success: function(data){
               var options = {
                   withQuotes: true
               };
               $("#json-response").jsonViewer(data, options);
           },
           error: function (jqXHR, error, errorThrown) {
               console.log(jqXHR);
               console.log(error);
               console.log(errorThrown);
               var status = jqXHR.status;
               if (status == 401) {
                   layer.msg("无权限访问，查看oauth2是否配置正确！");
               } else {
                   layer.msg("访问失败，查看传参是否正确");
               }
           }
       });
   }
}

function getToken() {
    var accessToken = sessionStorage.getItem('access_token');
    var exp = sessionStorage.getItem('exp_time');
    var nowTime = Date.parse(new Date());
    exp = exp - 60;
    if (exp != null && exp != undefined && exp != "" && nowTime < exp) {
        return accessToken;
    } else {
        accessToken = getNewAccessToken();
        return accessToken;
    }
}


function getNewAccessToken() {
    var authUrl = sessionStorage.getItem('auth_url');
    var username = sessionStorage.getItem('auth-username');
    var pwd = sessionStorage.getItem('auth-pwd');
    var clientId = sessionStorage.getItem('auth-client-id');
    var clientSecret = sessionStorage.getItem('auth-client-secret');
    authUrl = authUrl + '/oauth/token?grant_type=password&username=' + encodeURIComponent(username) + '&password='+ pwd + '&client_id=' + clientId + '&client_secret=' + clientSecret
    var accessToken = "";
    $.ajax({
        type : "post",
        url : authUrl,
        async: false,
        cache: false,
        contentType : "application/json; charset=utf-8",
        success : function(data) {
            console.log(data.access_token);
            sessionStorage.setItem('access_token',data.access_token);
            var exp = data.expires_in;
            var nowTime = Date.parse(new Date());
            nowTime = nowTime + exp;
            sessionStorage.setItem('exp_time',nowTime);
            accessToken = data.access_token;
            console.log(nowTime);
        },
        error : function(XMLHttpRequest, textStatus, errorThrown) {
            layer.msg("获取token失败，请检查配置信息是否正确！");
        }
    });

    return accessToken;
}


//请求类型
function changeParameterType(el){
    var operationId = $(el).attr("operationId");
    var type = $(el).attr("type");
    $("#content_type_"+operationId).val(type);
    $(el).addClass("layui-btn-normal").removeClass("layui-btn-primary");
    if("form" == type){
        $("#text_tp_"+operationId).hide();
        $("#table_tp_"+operationId).show();
        $("#pt_json_"+operationId).addClass("layui-btn-primary").removeClass("layui-btn-normal");
    }else if("json" == type){
       $("#text_tp_"+operationId).show();
       $("#table_tp_"+operationId).hide();
       $("#pt_form_"+operationId).addClass("layui-btn-primary").removeClass("layui-btn-normal");
    }
}
