/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.feign.common.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ObjectMapperUtils {
    private static final Logger logger = LoggerFactory.getLogger(ObjectMapperUtils.class);
    private static ObjectMapper mapper = new ObjectMapper();

    public static <T> T toObject(String json, Class<T> valueType) {
        if (!StringUtils.isEmpty((Object)json) && null != valueType) {
            try {
                return (T)mapper.readValue(json, valueType);
            }
            catch (Exception e) {
                logger.warn("toObject", (Throwable)e);
            }
        }
        return null;
    }

    public static String toJson(Object value) {
        try {
            return mapper.writeValueAsString(value);
        }
        catch (Exception e) {
            logger.warn("toJson", (Throwable)e);
            return null;
        }
    }

    public static <T> T convertValue(Object o, Class<T> valueType) {
        return (T)mapper.convertValue(o, valueType);
    }
}

