package cn.gtmap.gtc.bpmnio.common.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * @program: workflow
 * @description: 模型的详细
 * @author: zhouk
 * @create: 2019-10-23 16:16
 **/
@Getter
@Setter
public class ModelDto {

    private String id;

    private String name;

    private String modelKey;

    private String description;

    private String icon;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date updateAt;

    private String modelEditorXml;

    private String thumbnail;

    private String configuration;

    private List<CategoryTagDto> categoryTagDtos;

    @Override
    public String toString() {
        return "ModelDto{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", modelKey='" + modelKey + '\'' +
                ", description='" + description + '\'' +
                ", modelEditorXml='" + modelEditorXml + '\'' +
                '}';
    }
}
