package cn.gtmap.gtc.bpmnio.common.domain.es.listview;

import cn.gtmap.gtc.bpmnio.common.domain.es.OperationDto;
import cn.gtmap.gtc.bpmnio.common.enums.WorkflowInstanceState;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @program: bpmnio
 * @description: 工作流实例Dto
 * @author: zhouk
 * @create: 2019-10-28 17:12
 **/
public class ListViewWorkflowInstanceDto {
    private String id;
    private String workflowId;
    private String workflowName;
    private Integer workflowVersion;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private OffsetDateTime startDate;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private OffsetDateTime endDate;
    private WorkflowInstanceState state;
    private String bpmnProcessId;
    private boolean hasActiveOperation = false;
    private List<OperationDto> operations = new ArrayList();

    public ListViewWorkflowInstanceDto() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public Integer getWorkflowVersion() {
        return this.workflowVersion;
    }

    public void setWorkflowVersion(Integer workflowVersion) {
        this.workflowVersion = workflowVersion;
    }

    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public WorkflowInstanceState getState() {
        return state;
    }

    public void setState(WorkflowInstanceState state) {
        this.state = state;
    }

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public void setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
    }

    public boolean isHasActiveOperation() {
        return this.hasActiveOperation;
    }

    public void setHasActiveOperation(boolean hasActiveOperation) {
        this.hasActiveOperation = hasActiveOperation;
    }

    public List<OperationDto> getOperations() {
        return this.operations;
    }

    public void setOperations(List<OperationDto> operations) {
        this.operations = operations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        } else if (o != null && this.getClass() == o.getClass()) {
            ListViewWorkflowInstanceDto that;
            label105: {
                that = (ListViewWorkflowInstanceDto)o;
                if (this.id != null) {
                    if (this.id.equals(that.id)) {
                        break label105;
                    }
                } else if (that.id == null) {
                    break label105;
                }

                return false;
            }

            label98: {
                if (this.workflowId != null) {
                    if (this.workflowId.equals(that.workflowId)) {
                        break label98;
                    }
                } else if (that.workflowId == null) {
                    break label98;
                }

                return false;
            }

            if (this.workflowName != null) {
                if (!this.workflowName.equals(that.workflowName)) {
                    return false;
                }
            } else if (that.workflowName != null) {
                return false;
            }

            if (this.workflowVersion != null) {
                if (!this.workflowVersion.equals(that.workflowVersion)) {
                    return false;
                }
            } else if (that.workflowVersion != null) {
                return false;
            }

            label77: {
                if (this.startDate != null) {
                    if (this.startDate.equals(that.startDate)) {
                        break label77;
                    }
                } else if (that.startDate == null) {
                    break label77;
                }

                return false;
            }

            label70: {
                if (this.endDate != null) {
                    if (this.endDate.equals(that.endDate)) {
                        break label70;
                    }
                } else if (that.endDate == null) {
                    break label70;
                }

                return false;
            }

            if (this.state != that.state) {
                return false;
            } else {
                if (this.bpmnProcessId != null) {
                    if (this.bpmnProcessId.equals(that.bpmnProcessId)) {
                        return this.operations != null ? this.operations.equals(that.operations) : that.operations == null;
                    }
                } else if (that.bpmnProcessId == null) {
                    return this.operations != null ? this.operations.equals(that.operations) : that.operations == null;
                }

                return false;
            }
        } else {
            return false;
        }
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.workflowId != null ? this.workflowId.hashCode() : 0);
        result = 31 * result + (this.workflowName != null ? this.workflowName.hashCode() : 0);
        result = 31 * result + (this.workflowVersion != null ? this.workflowVersion.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.bpmnProcessId != null ? this.bpmnProcessId.hashCode() : 0);
        result = 31 * result + (this.operations != null ? this.operations.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("ListViewWorkflowInstanceDto %s (%s)", this.workflowName, this.workflowId);
    }
}
