package cn.gtmap.gtc.bpmnio.common.domain.es.listview;

import cn.gtmap.gtc.bpmnio.common.domain.es.SortingDto;
import cn.gtmap.gtc.bpmnio.common.exception.InvalidRequestException;

import java.util.ArrayList;
import java.util.List;

/**
 * @program: bpmnio
 * @description:
 * @author: zhouk
 * @create: 2019-10-29 15:17
 **/
public class ListViewRequestDto {
    public static final String SORT_BY_ID = "id";
    public static final String SORT_BY_START_DATE = "startDate";
    public static final String SORT_BY_END_DATE = "endDate";
    public static final String SORT_BY_WORKFLOW_NAME = "workflowName";
    public static final String SORT_BY_WORFLOW_VERSION = "workflowVersion";
    public static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    private List<ListViewQueryDto> queries = new ArrayList();
    private SortingDto sorting;

    public ListViewRequestDto() {
    }

    public ListViewRequestDto(String BpmnProcessId,Integer workflowVersion,SortingDto sorting) {
        List<ListViewQueryDto> listViewQueryDtos=new ArrayList<>();
        ListViewQueryDto listViewQueryDto=new ListViewQueryDto();
        listViewQueryDto.setBpmnProcessId(BpmnProcessId);
        listViewQueryDto.setWorkflowVersion(workflowVersion);

        listViewQueryDto.setActive(true);
        listViewQueryDto.setCanceled(true);
        listViewQueryDto.setFinished(true);
        listViewQueryDto.setCompleted(true);
        listViewQueryDto.setRunning(true);
        listViewQueryDto.setIncidents(true);

        listViewQueryDtos.add(listViewQueryDto);
        this.queries=listViewQueryDtos;
        this.sorting = sorting;
    }

    public ListViewRequestDto(List<ListViewQueryDto> queries) {
        this.queries = queries;
    }

    public List<ListViewQueryDto> getQueries() {
        return this.queries;
    }

    public void setQueries(List<ListViewQueryDto> queries) {
        this.queries = queries;
    }

    public SortingDto getSorting() {
        return this.sorting;
    }

    public void setSorting(SortingDto sorting) {
        if (sorting != null && !VALID_SORT_BY_VALUES.contains(sorting.getSortBy())) {
            throw new InvalidRequestException("SortBy parameter has invalid value: " + sorting.getSortBy());
        } else {
            this.sorting = sorting;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        } else if (o != null && this.getClass() == o.getClass()) {
            ListViewRequestDto that = (ListViewRequestDto)o;
            if (this.queries != null) {
                if (this.queries.equals(that.queries)) {
                    return this.sorting != null ? this.sorting.equals(that.sorting) : that.sorting == null;
                }
            } else if (that.queries == null) {
                return this.sorting != null ? this.sorting.equals(that.sorting) : that.sorting == null;
            }

            return false;
        } else {
            return false;
        }
    }

    public int hashCode() {
        int result = this.queries != null ? this.queries.hashCode() : 0;
        result = 31 * result + (this.sorting != null ? this.sorting.hashCode() : 0);
        return result;
    }

    static {
        VALID_SORT_BY_VALUES.add("id");
        VALID_SORT_BY_VALUES.add("startDate");
        VALID_SORT_BY_VALUES.add("endDate");
        VALID_SORT_BY_VALUES.add("workflowName");
        VALID_SORT_BY_VALUES.add("workflowVersion");
    }
}
