package cn.gtmap.gtc.bpmnio.common.domain.es.incidents;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

/**
 * @program: bpmnio
 * @description:
 * @author: zhouk
 * @create: 2019-10-30 14:29
 **/
public class IncidentsByWorkflowGroupStatisticsDto {
    public static final Comparator<IncidentsByWorkflowGroupStatisticsDto> COMPARATOR = new IncidentsByWorkflowGroupStatisticsDto.IncidentsByWorkflowGroupStatisticsDtoComparator();
    private String bpmnProcessId;
    private String workflowName;
    private long instancesWithActiveIncidentsCount;
    private long activeInstancesCount;
    @JsonDeserialize(
            as = TreeSet.class
    )
    private Set<IncidentByWorkflowStatisticsDto> workflows;

    public IncidentsByWorkflowGroupStatisticsDto() {
        this.workflows = new TreeSet(IncidentByWorkflowStatisticsDto.COMPARATOR);
    }

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public void setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public long getInstancesWithActiveIncidentsCount() {
        return this.instancesWithActiveIncidentsCount;
    }

    public void setInstancesWithActiveIncidentsCount(long instancesWithActiveIncidentsCount) {
        this.instancesWithActiveIncidentsCount = instancesWithActiveIncidentsCount;
    }

    public long getActiveInstancesCount() {
        return this.activeInstancesCount;
    }

    public void setActiveInstancesCount(long activeInstancesCount) {
        this.activeInstancesCount = activeInstancesCount;
    }

    public Set<IncidentByWorkflowStatisticsDto> getWorkflows() {
        return this.workflows;
    }

    public void setWorkflows(Set<IncidentByWorkflowStatisticsDto> workflows) {
        this.workflows = workflows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        } else if (o != null && this.getClass() == o.getClass()) {
            IncidentsByWorkflowGroupStatisticsDto that = (IncidentsByWorkflowGroupStatisticsDto)o;
            if (this.instancesWithActiveIncidentsCount != that.instancesWithActiveIncidentsCount) {
                return false;
            } else if (this.activeInstancesCount != that.activeInstancesCount) {
                return false;
            } else {
                label46: {
                    if (this.bpmnProcessId != null) {
                        if (this.bpmnProcessId.equals(that.bpmnProcessId)) {
                            break label46;
                        }
                    } else if (that.bpmnProcessId == null) {
                        break label46;
                    }

                    return false;
                }

                if (this.workflowName != null) {
                    if (!this.workflowName.equals(that.workflowName)) {
                        return false;
                    }
                } else if (that.workflowName != null) {
                    return false;
                }

                return this.workflows != null ? this.workflows.equals(that.workflows) : that.workflows == null;
            }
        } else {
            return false;
        }
    }

    public int hashCode() {
        int result = this.bpmnProcessId != null ? this.bpmnProcessId.hashCode() : 0;
        result = 31 * result + (this.workflowName != null ? this.workflowName.hashCode() : 0);
        result = 31 * result + (int)(this.instancesWithActiveIncidentsCount ^ this.instancesWithActiveIncidentsCount >>> 32);
        result = 31 * result + (int)(this.activeInstancesCount ^ this.activeInstancesCount >>> 32);
        result = 31 * result + (this.workflows != null ? this.workflows.hashCode() : 0);
        return result;
    }

    public static class IncidentsByWorkflowGroupStatisticsDtoComparator implements Comparator<IncidentsByWorkflowGroupStatisticsDto> {
        public IncidentsByWorkflowGroupStatisticsDtoComparator() {
        }

        public int compare(IncidentsByWorkflowGroupStatisticsDto o1, IncidentsByWorkflowGroupStatisticsDto o2) {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            } else if (o2 == null) {
                return -1;
            } else if (o1.equals(o2)) {
                return 0;
            } else {
                int result = Long.compare(o2.getInstancesWithActiveIncidentsCount(), o1.getInstancesWithActiveIncidentsCount());
                if (result == 0) {
                    result = Long.compare(o2.getActiveInstancesCount(), o1.getActiveInstancesCount());
                    if (result == 0) {
                        result = o1.getBpmnProcessId().compareTo(o2.getBpmnProcessId());
                    }
                }

                return result;
            }
        }
    }
}
