package cn.gtmap.gtc.bpmnio.common.domain.es.incidents;

import cn.gtmap.gtc.bpmnio.common.domain.es.OperationDto;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;


/**
 * @program: bpmnio
 * @description: 事件
 * @author: zhouk
 * @create: 2019-10-30 14:10
 **/
public class IncidentDto {
    public static final Comparator<IncidentDto> INCIDENT_DEFAULT_COMPARATOR = (o1, o2) -> {
        return o1.getErrorType().equals(o2.getErrorType()) ? o1.getId().compareTo(o2.getId()) : o1.getErrorType().compareTo(o2.getErrorType());
    };
    private String id;
    private String errorType;
    private String errorMessage;
    private String flowNodeId;
    private String flowNodeInstanceId;
    private Long jobId;
    private OffsetDateTime creationTime;
    private boolean hasActiveOperation = false;
    private OperationDto lastOperation;

    public IncidentDto() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getFlowNodeId() {
        return this.flowNodeId;
    }

    public void setFlowNodeId(String flowNodeId) {
        this.flowNodeId = flowNodeId;
    }

    public String getFlowNodeInstanceId() {
        return this.flowNodeInstanceId;
    }

    public void setFlowNodeInstanceId(String flowNodeInstanceId) {
        this.flowNodeInstanceId = flowNodeInstanceId;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public void setJobId(Long jobId) {
        this.jobId = jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId != null ? Long.valueOf(jobId) : null;
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public boolean isHasActiveOperation() {
        return this.hasActiveOperation;
    }

    public void setHasActiveOperation(boolean hasActiveOperation) {
        this.hasActiveOperation = hasActiveOperation;
    }

    public OperationDto getLastOperation() {
        return this.lastOperation;
    }

    public void setLastOperation(OperationDto lastOperation) {
        this.lastOperation = lastOperation;
    }

    public static List<IncidentDto> sortDefault(List<IncidentDto> incidents) {
        Collections.sort(incidents, INCIDENT_DEFAULT_COMPARATOR);
        return incidents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        } else if (o != null && this.getClass() == o.getClass()) {
            IncidentDto that = (IncidentDto)o;
            if (this.hasActiveOperation != that.hasActiveOperation) {
                return false;
            } else {
                label104: {
                    if (this.id != null) {
                        if (this.id.equals(that.id)) {
                            break label104;
                        }
                    } else if (that.id == null) {
                        break label104;
                    }

                    return false;
                }

                if (this.errorType != null) {
                    if (!this.errorType.equals(that.errorType)) {
                        return false;
                    }
                } else if (that.errorType != null) {
                    return false;
                }

                label90: {
                    if (this.errorMessage != null) {
                        if (this.errorMessage.equals(that.errorMessage)) {
                            break label90;
                        }
                    } else if (that.errorMessage == null) {
                        break label90;
                    }

                    return false;
                }

                if (this.flowNodeId != null) {
                    if (!this.flowNodeId.equals(that.flowNodeId)) {
                        return false;
                    }
                } else if (that.flowNodeId != null) {
                    return false;
                }

                if (this.flowNodeInstanceId != null) {
                    if (!this.flowNodeInstanceId.equals(that.flowNodeInstanceId)) {
                        return false;
                    }
                } else if (that.flowNodeInstanceId != null) {
                    return false;
                }

                if (this.jobId != null) {
                    if (!this.jobId.equals(that.jobId)) {
                        return false;
                    }
                } else if (that.jobId != null) {
                    return false;
                }

                if (this.creationTime != null) {
                    if (this.creationTime.equals(that.creationTime)) {
                        return this.lastOperation != null ? this.lastOperation.equals(that.lastOperation) : that.lastOperation == null;
                    }
                } else if (that.creationTime == null) {
                    return this.lastOperation != null ? this.lastOperation.equals(that.lastOperation) : that.lastOperation == null;
                }

                return false;
            }
        } else {
            return false;
        }
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.errorType != null ? this.errorType.hashCode() : 0);
        result = 31 * result + (this.errorMessage != null ? this.errorMessage.hashCode() : 0);
        result = 31 * result + (this.flowNodeId != null ? this.flowNodeId.hashCode() : 0);
        result = 31 * result + (this.flowNodeInstanceId != null ? this.flowNodeInstanceId.hashCode() : 0);
        result = 31 * result + (this.jobId != null ? this.jobId.hashCode() : 0);
        result = 31 * result + (this.creationTime != null ? this.creationTime.hashCode() : 0);
        result = 31 * result + (this.hasActiveOperation ? 1 : 0);
        result = 31 * result + (this.lastOperation != null ? this.lastOperation.hashCode() : 0);
        return result;
    }
}
