package cn.gtmap.gtc.bpmnio.common.domain.es.activity;

import cn.gtmap.gtc.bpmnio.common.enums.ActivityState;
import cn.gtmap.gtc.bpmnio.common.enums.ActivityType;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.time.OffsetDateTime;
import java.util.*;

/**
 * @program: bpmnio
 * @description:
 * @author: zhouk
 * @create: 2019-10-29 15:55
 **/
public class ActivityInstanceDto {
    private String id;
    private ActivityType type;
    private ActivityState state;
    private String activityId;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private OffsetDateTime startDate;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private OffsetDateTime endDate;
    private String parentId;
    private List<ActivityInstanceDto> children = new ArrayList();

    public ActivityInstanceDto() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ActivityState getState() {
        return this.state;
    }

    public void setState(ActivityState state) {
        this.state = state;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public ActivityType getType() {
        return this.type;
    }

    public void setType(ActivityType type) {
        this.type = type;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public List<ActivityInstanceDto> getChildren() {
        return this.children;
    }

    public void setChildren(List<ActivityInstanceDto> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        } else if (o != null && this.getClass() == o.getClass()) {
            ActivityInstanceDto that = (ActivityInstanceDto)o;
            if (this.id != null) {
                if (!this.id.equals(that.id)) {
                    return false;
                }
            } else if (that.id != null) {
                return false;
            }

            if (this.type != that.type) {
                return false;
            } else if (this.state != that.state) {
                return false;
            } else {
                if (this.activityId != null) {
                    if (!this.activityId.equals(that.activityId)) {
                        return false;
                    }
                } else if (that.activityId != null) {
                    return false;
                }

                if (this.startDate != null) {
                    if (!this.startDate.equals(that.startDate)) {
                        return false;
                    }
                } else if (that.startDate != null) {
                    return false;
                }

                label61: {
                    if (this.endDate != null) {
                        if (this.endDate.equals(that.endDate)) {
                            break label61;
                        }
                    } else if (that.endDate == null) {
                        break label61;
                    }

                    return false;
                }

                if (this.parentId != null) {
                    if (!this.parentId.equals(that.parentId)) {
                        return false;
                    }
                } else if (that.parentId != null) {
                    return false;
                }

                return this.children != null ? this.children.equals(that.children) : that.children == null;
            }
        } else {
            return false;
        }
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.activityId != null ? this.activityId.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
        result = 31 * result + (this.parentId != null ? this.parentId.hashCode() : 0);
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        return result;
    }
}
