package cn.gtmap.gtc.bpmnio.common.domain.es;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/**
 * @program: bpmnio
 * @description:
 * @author: zhouk
 * @create: 2019-10-31 10:00
 **/
public class WorkflowGroupDto {
    private String bpmnProcessId;
    private String name;
    private List<WorkflowDto> workflows;

    public WorkflowGroupDto() {
    }

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public void setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<WorkflowDto> getWorkflows() {
        return this.workflows;
    }

    public void setWorkflows(List<WorkflowDto> workflows) {
        this.workflows = workflows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        } else if (o != null && this.getClass() == o.getClass()) {
            WorkflowGroupDto that = (WorkflowGroupDto)o;
            return this.bpmnProcessId != null ? this.bpmnProcessId.equals(that.bpmnProcessId) : that.bpmnProcessId == null;
        } else {
            return false;
        }
    }

    public int hashCode() {
        return this.bpmnProcessId != null ? this.bpmnProcessId.hashCode() : 0;
    }

    public static class WorkflowGroupComparator implements Comparator<WorkflowGroupDto> {
        public WorkflowGroupComparator() {
        }

        public int compare(WorkflowGroupDto o1, WorkflowGroupDto o2) {
            if (o1.getName() == null && o2.getName() == null) {
                return o1.getBpmnProcessId().compareTo(o2.getBpmnProcessId());
            } else if (o1.getName() == null) {
                return 1;
            } else if (o2.getName() == null) {
                return -1;
            } else {
                return !o1.getName().equals(o2.getName()) ? o1.getName().compareTo(o2.getName()) : o1.getBpmnProcessId().compareTo(o2.getBpmnProcessId());
            }
        }
    }
}
