package cn.gtmap.gtc.bpmnio.common.domain.es;

import cn.gtmap.gtc.bpmnio.common.enums.OperationState;
import cn.gtmap.gtc.bpmnio.common.enums.OperationType;

import java.time.OffsetDateTime;

/**
 * @program: bpmnio
 * @description: 操作的
 * @author: zhouk
 * @create: 2019-10-29 08:38
 **/
public class OperationDto {
    private String id;
    private OperationType type;
    private OffsetDateTime startDate;
    private OffsetDateTime endDate;
    private OperationState state;
    private String errorMessage;

    public OperationDto() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OperationType getType() {
        return this.type;
    }

    public void setType(OperationType type) {
        this.type = type;
    }

    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public OperationState getState() {
        return this.state;
    }

    public void setState(OperationState state) {
        this.state = state;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }



    public boolean equals(Object o) {
        if (this == o) {
            return true;
        } else if (o != null && this.getClass() == o.getClass()) {
            OperationDto that;
            label61: {
                that = (OperationDto)o;
                if (this.id != null) {
                    if (this.id.equals(that.id)) {
                        break label61;
                    }
                } else if (that.id == null) {
                    break label61;
                }

                return false;
            }

            if (this.type != that.type) {
                return false;
            } else {
                if (this.startDate != null) {
                    if (!this.startDate.equals(that.startDate)) {
                        return false;
                    }
                } else if (that.startDate != null) {
                    return false;
                }

                if (this.endDate != null) {
                    if (!this.endDate.equals(that.endDate)) {
                        return false;
                    }
                } else if (that.endDate != null) {
                    return false;
                }

                if (this.state != that.state) {
                    return false;
                } else {
                    return this.errorMessage != null ? this.errorMessage.equals(that.errorMessage) : that.errorMessage == null;
                }
            }
        } else {
            return false;
        }
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.errorMessage != null ? this.errorMessage.hashCode() : 0);
        return result;
    }
}

