package cn.gtmap.gtc.bpmnio.common.clients;

import cn.gtmap.gtc.bpmnio.common.domain.ModelTypeDto;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient("${app.services.bpmnio-define:bpmnio-define}")
@RequestMapping("/define/rest/model-type")
public interface ModelTypeCilent {

    @ApiOperation(value = "查询相关模型类型")
    @GetMapping(value = "/findById/{id}")
    ModelTypeDto findById(@PathVariable("id") String id);

    @ApiOperation(value = "查询全部")
    @GetMapping(value = "/findAll/{serviceGroupId}")
    List<ModelTypeDto> findAll(@PathVariable("serviceGroupId")String serviceGroupId);

    @ApiOperation(value = "保存")
    @PutMapping(value = "/save")
    ModelTypeDto save(@RequestBody ModelTypeDto ModelTypeDto) ;
    @ApiOperation(value = "批量保存")
    @PutMapping(value = "/saveAll")
    List<ModelTypeDto> saveAll(@RequestBody List<ModelTypeDto> ModelTypeDtoList);

    @ApiOperation(value = "单个删除")
    @DeleteMapping(value = "/delete-by-id/{id}")
    void deleteById(@PathVariable("id") String id);

    @ApiOperation(value = "整个项目删除")
    @DeleteMapping(value = "/delete")
    void delete(@RequestParam("serviceGroupId") String serviceGroupId);

    @ApiOperation(value = "批量删除")
    @DeleteMapping(value = "/deleteAll")
    void deleteAll(@RequestBody List<ModelTypeDto> propertiesDtoList) ;
}
