package cn.gtmap.gtc.bpmnio.common.clients;


import cn.gtmap.gtc.bpmnio.common.domain.ModelDto;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

@FeignClient("${app.services.bpmnio-define:bpmnio-define}")
@RequestMapping("/define/rest")
public interface ModelClient {

    /**
     * 分页查询所有模型
     * @param name
     * @param page
     * @return
     */
    @GetMapping("/models")
    public Page<ModelDto> findAll(@RequestParam(value = "name",required = false) String name, Pageable page);

    /**
     * 根据名称和类型分页查询所有模型
     * @param name
     * @param page
     * @return
     */
    @ApiOperation(value = "根据名称和类型分页查询所有模型")
    @GetMapping("/models/tag-or-name")
    public Page<ModelDto> findAllByTag(@RequestParam(value = "name",required = false) String name,
                                       @RequestParam(value = "tagIds",required = false) String tagIds,Pageable page);

    /**
     * 获取详细信息
     * @param id
     * @return
     */
    @GetMapping("/model/{id}")
    public ModelDto findById(@PathVariable("id") String id);


    /**
     * 保存模型
     * @param modelDto
     * @return
     */
    @PostMapping("/model")
    public ModelDto save(@RequestBody ModelDto modelDto);

    /**
     * 删除单个模型
     * @param Id
     * @return
     * @
     */
    @DeleteMapping("/model")
    public Boolean delete(@RequestParam("Id")String Id);

    /**
     * 按照条件删除模型
     * @param modelDto
     * @return
     */
    @DeleteMapping("/model/condition")
    public Boolean delete(@RequestBody ModelDto modelDto);
}
