/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.bpmnio.common.domain.es.incidents;

import cn.gtmap.gtc.bpmnio.common.domain.es.incidents.IncidentByWorkflowStatisticsDto;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class IncidentsByWorkflowGroupStatisticsDto {
    public static final Comparator<IncidentsByWorkflowGroupStatisticsDto> COMPARATOR = new IncidentsByWorkflowGroupStatisticsDtoComparator();
    private String bpmnProcessId;
    private String workflowName;
    private long instancesWithActiveIncidentsCount;
    private long activeInstancesCount;
    @JsonDeserialize(as=TreeSet.class)
    private Set<IncidentByWorkflowStatisticsDto> workflows = new TreeSet<IncidentByWorkflowStatisticsDto>(IncidentByWorkflowStatisticsDto.COMPARATOR);

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public void setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public long getInstancesWithActiveIncidentsCount() {
        return this.instancesWithActiveIncidentsCount;
    }

    public void setInstancesWithActiveIncidentsCount(long instancesWithActiveIncidentsCount) {
        this.instancesWithActiveIncidentsCount = instancesWithActiveIncidentsCount;
    }

    public long getActiveInstancesCount() {
        return this.activeInstancesCount;
    }

    public void setActiveInstancesCount(long activeInstancesCount) {
        this.activeInstancesCount = activeInstancesCount;
    }

    public Set<IncidentByWorkflowStatisticsDto> getWorkflows() {
        return this.workflows;
    }

    public void setWorkflows(Set<IncidentByWorkflowStatisticsDto> workflows) {
        this.workflows = workflows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            IncidentsByWorkflowGroupStatisticsDto that = (IncidentsByWorkflowGroupStatisticsDto)o;
            if (this.instancesWithActiveIncidentsCount != that.instancesWithActiveIncidentsCount) {
                return false;
            }
            if (this.activeInstancesCount != that.activeInstancesCount) {
                return false;
            }
            if (!(this.bpmnProcessId != null ? this.bpmnProcessId.equals(that.bpmnProcessId) : that.bpmnProcessId == null)) {
                return false;
            }
            if (this.workflowName != null ? !this.workflowName.equals(that.workflowName) : that.workflowName != null) {
                return false;
            }
            return this.workflows != null ? this.workflows.equals(that.workflows) : that.workflows == null;
        }
        return false;
    }

    public int hashCode() {
        int result = this.bpmnProcessId != null ? this.bpmnProcessId.hashCode() : 0;
        result = 31 * result + (this.workflowName != null ? this.workflowName.hashCode() : 0);
        result = 31 * result + (int)(this.instancesWithActiveIncidentsCount ^ this.instancesWithActiveIncidentsCount >>> 32);
        result = 31 * result + (int)(this.activeInstancesCount ^ this.activeInstancesCount >>> 32);
        result = 31 * result + (this.workflows != null ? this.workflows.hashCode() : 0);
        return result;
    }

    public static class IncidentsByWorkflowGroupStatisticsDtoComparator
    implements Comparator<IncidentsByWorkflowGroupStatisticsDto> {
        @Override
        public int compare(IncidentsByWorkflowGroupStatisticsDto o1, IncidentsByWorkflowGroupStatisticsDto o2) {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            int result = Long.compare(o2.getInstancesWithActiveIncidentsCount(), o1.getInstancesWithActiveIncidentsCount());
            if (result == 0 && (result = Long.compare(o2.getActiveInstancesCount(), o1.getActiveInstancesCount())) == 0) {
                result = o1.getBpmnProcessId().compareTo(o2.getBpmnProcessId());
            }
            return result;
        }
    }
}

