package cn.gtmap.gtc.bpmnio.common.enums;

public enum WorkflowInstanceState {

    ACTIVE,
    INCIDENT,
    COMPLETED,
    CANCELED,
    UNKNOWN,
    UNSPECIFIED;

    private WorkflowInstanceState() {
    }

    public static WorkflowInstanceState getState(WorkflowInstanceState state) {
        if (state == null) {
            return UNSPECIFIED;
        } else {
            WorkflowInstanceState stateDto = valueOf(state.name());
            return stateDto == null ? UNKNOWN : stateDto;
        }
    }
}
