/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.statistics.web.rest;

import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.workflow.Constant;
import cn.gtmap.gtc.workflow.clients.define.v1.ProcessDefineClient;
import cn.gtmap.gtc.workflow.domain.define.ProcessDefinedDto;
import cn.gtmap.gtc.workflow.domain.manage.StatisticsTaskDto;
import cn.gtmap.gtc.workflow.domain.statistics.BaseTaskStatisticsInfo;
import cn.gtmap.gtc.workflow.domain.statistics.OrgTaskStatisticsInfo;
import cn.gtmap.gtc.workflow.domain.statistics.UserTaskCountDto;
import cn.gtmap.gtc.workflow.domain.statistics.UserTaskStatisticsInfo;
import cn.gtmap.gtc.workflow.domain.statistics.UserTaskStatisticsTimeDto;
import cn.gtmap.gtc.workflow.enums.manage.TaskStatus;
import cn.gtmap.gtc.workflow.enums.statistics.StatisticsType;
import cn.gtmap.gtc.workflow.statistics.manager.AccountManager;
import cn.gtmap.gtc.workflow.statistics.service.StatisticsTaskService;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/task-statistics/v1"})
@Api(value="TaskStatisticsController", tags={"\u4efb\u52a1\u7edf\u8ba1"})
public class TaskStatisticsController {
    @Autowired
    private StatisticsTaskService statisticsTaskService;
    @Autowired
    private ProcessDefineClient processDefineClient;
    @Autowired
    private AccountManager accountManager;

    @GetMapping(value={"/users/{userId}/active-tasks"})
    public List<StatisticsTaskDto> getActiveByUserId(@PathVariable(value="userId") String userId) {
        return this.statisticsTaskService.selectActiveByUserId(userId);
    }

    @GetMapping(value={"/orgs/statistics"})
    public List<OrgTaskStatisticsInfo> getStatisticsOfAllOrgs(@RequestParam(value="startTime", required=false) Long startTime, @RequestParam(value="endTime", required=false) Long endTime, @RequestParam(value="category", required=false, defaultValue="") String category, @RequestParam(value="taskName", required=false, defaultValue="") String taskName, @RequestParam(value="statisticsType") String statisticsType) {
        Map params = this.getQueryMap(statisticsType, startTime, endTime, category, taskName, null);
        List list = this.statisticsTaskService.getStatisticsOfAllOrgs(params);
        this.supplyDeptInfo(list);
        this.supplyDefInfo(list);
        return list;
    }

    private Map<String, Object> getQueryMap(String statisticsType, Long startTime, Long endTime, String category, String taskName, String orgId) {
        StatisticsType type = StatisticsType.enumValue((String)statisticsType);
        if (type == null) {
            throw new IllegalArgumentException("\u9519\u8bef\u7edf\u8ba1\u7c7b\u578b");
        }
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("category", category);
        params.put("taskName", taskName);
        String starTimeName = "taskStartStartTime";
        String endTimeName = "taskStartEndTime";
        if (type.equals((Object)StatisticsType.END_STATISTIC)) {
            starTimeName = "taskEndStartTime";
            endTimeName = "taskEndEndTime";
            params.put("taskStatus", TaskStatus.END.getValue());
            params.put("taskEnd", "true");
        } else if (type.equals((Object)StatisticsType.RUN_STATISTIC)) {
            params.put("taskStatus", TaskStatus.RUNNING.getValue());
        }
        if (null != startTime) {
            params.put(starTimeName, startTime - Constant.B_UTC);
        }
        if (endTime != null) {
            params.put(endTimeName, endTime - Constant.B_UTC);
        }
        if (!StringUtils.isEmpty((Object)orgId)) {
            params.put("orgId", orgId);
        }
        return params;
    }

    @GetMapping(value={"/users/statistics"})
    public List<UserTaskStatisticsInfo> getStatisticsByOrg(@RequestParam(value="startTime", required=false) Long startTime, @RequestParam(value="endTime", required=false) Long endTime, @RequestParam(value="orgId", required=false, defaultValue="") String orgId, @RequestParam(value="category", required=false, defaultValue="") String category, @RequestParam(value="taskName", required=false, defaultValue="") String taskName, @RequestParam(value="statisticsType") String statisticsType) {
        Map params = this.getQueryMap(statisticsType, startTime, endTime, category, taskName, orgId);
        List list = this.statisticsTaskService.getStatisticsByOrg(params);
        this.supplyUserInfo(list);
        this.supplyDefInfo(list);
        return list;
    }

    @GetMapping(value={"/process/task/statistics/time"})
    public List<UserTaskStatisticsTimeDto> getUserStatisticsTime(@RequestParam(value="startTime", required=false) Long startTime, @RequestParam(value="endTime", required=false) Long endTime, @RequestParam(value="orgId", required=false, defaultValue="") String orgId, @RequestParam(value="category", required=false, defaultValue="") String category, @RequestParam(value="taskName", required=false, defaultValue="") String taskName) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("category", category);
        params.put("taskName", taskName);
        if (null != startTime) {
            params.put("startTime", startTime - Constant.B_UTC);
        }
        if (endTime != null) {
            params.put("endTime", endTime - Constant.B_UTC);
        }
        params.put("orgId", orgId);
        List list = this.statisticsTaskService.getUserStatisticsTime(params);
        this.supplyUserInfo(list);
        this.supplyDefInfo(list);
        return list;
    }

    @GetMapping(value={"/users/task/count"})
    public List<UserTaskCountDto> queryUserTaskCount(@RequestParam(value="username") String username, @RequestParam(value="taskStatus", required=false) Integer taskStatus, @RequestParam(value="startTime") long startTime, @RequestParam(value="endTime") long endTime, @RequestParam(value="dateType") String dateType) {
        return this.statisticsTaskService.queryUserTaskCount(username, taskStatus, Long.valueOf(startTime - Constant.B_UTC), Long.valueOf(endTime - Constant.B_UTC), dateType);
    }

    @GetMapping(value={"/users/{username}/statistics"})
    public List<BaseTaskStatisticsInfo> getStatisticsByUser(@RequestParam(value="startTime", required=false) Long startTime, @RequestParam(value="endTime", required=false) Long endTime, @PathVariable(value="username") String username, @RequestParam(value="category", required=false, defaultValue="") String category, @RequestParam(value="taskName", required=false, defaultValue="") String taskName) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("category", category);
        params.put("taskName", taskName);
        if (null != startTime) {
            params.put("startTime", startTime - Constant.B_UTC);
        }
        if (endTime != null) {
            params.put("endTime", endTime - Constant.B_UTC);
        }
        params.put("userId", username);
        List list = this.statisticsTaskService.getStatisticsByUser(params);
        this.supplyDefInfo(list);
        return list;
    }

    private void supplyDeptInfo(List<OrgTaskStatisticsInfo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (OrgTaskStatisticsInfo deptTaskStatisticsInfo : list) {
            ids.add(deptTaskStatisticsInfo.getOrgId());
        }
        List organizationDtoList = this.accountManager.findOrgByIds(ids);
        if (!CollectionUtils.isEmpty((Collection)organizationDtoList)) {
            HashMap nameMap = Maps.newHashMap();
            for (OrganizationDto dto : organizationDtoList) {
                nameMap.put(dto.getId(), dto.getName());
            }
            HashMap codeMap = Maps.newHashMap();
            for (OrganizationDto dto : organizationDtoList) {
                codeMap.put(dto.getId(), dto.getCode());
            }
            for (OrgTaskStatisticsInfo info : list) {
                info.setOrgName(MapUtils.getString((Map)nameMap, (Object)info.getOrgId(), (String)""));
                info.setOrgCode(MapUtils.getString((Map)codeMap, (Object)info.getOrgId(), (String)""));
            }
        }
    }

    private void supplyUserInfo(List<? extends UserTaskStatisticsInfo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (UserTaskStatisticsInfo userTaskStatisticsInfo : list) {
            if (ids.contains(userTaskStatisticsInfo.getUsername())) continue;
            ids.add(userTaskStatisticsInfo.getUsername());
        }
        List userDtoList = this.accountManager.listUserByUserNames(ids);
        if (!CollectionUtils.isEmpty((Collection)userDtoList)) {
            HashMap hashMap = Maps.newHashMap();
            HashMap orgIdMap = Maps.newHashMap();
            HashMap orgNameMap = Maps.newHashMap();
            for (UserDto userDto : userDtoList) {
                hashMap.put(userDto.getUsername(), userDto.getAlias());
                List orgs = userDto.getOrgRecordList();
                if (CollectionUtils.isEmpty((Collection)orgs)) continue;
                String orgId = "";
                String orgName = "";
                for (OrganizationDto organizationDto : orgs) {
                    orgId = orgId.concat(organizationDto.getId()).concat(",");
                    orgName = orgName.concat(organizationDto.getName()).concat(",");
                }
                if (!StringUtils.isEmpty((Object)orgId)) {
                    orgId = orgId.substring(0, orgId.length() - 1);
                    orgIdMap.put(userDto.getUsername(), orgId);
                }
                if (StringUtils.isEmpty((Object)orgName)) continue;
                orgName = orgName.substring(0, orgName.length() - 1);
                orgNameMap.put(userDto.getUsername(), orgName);
            }
            for (UserTaskStatisticsInfo userTaskStatisticsInfo : list) {
                userTaskStatisticsInfo.setUserAlias(MapUtils.getString((Map)hashMap, (Object)userTaskStatisticsInfo.getUsername(), (String)""));
                userTaskStatisticsInfo.setOrgId(MapUtils.getString((Map)orgIdMap, (Object)userTaskStatisticsInfo.getUsername(), (String)""));
                userTaskStatisticsInfo.setOrgName(MapUtils.getString((Map)orgNameMap, (Object)userTaskStatisticsInfo.getUsername(), (String)""));
            }
        }
    }

    private void supplyDefInfo(List<? extends BaseTaskStatisticsInfo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List defList = this.processDefineClient.getProcessDefineList("");
        if (!CollectionUtils.isEmpty((Collection)defList)) {
            HashMap<String, String> nameMap = new HashMap<String, String>();
            for (ProcessDefinedDto processDefinedDto : defList) {
                nameMap.put(processDefinedDto.getKey(), processDefinedDto.getName());
            }
            for (BaseTaskStatisticsInfo baseTaskStatisticsInfo : list) {
                baseTaskStatisticsInfo.setProcDefName(MapUtils.getString(nameMap, (Object)baseTaskStatisticsInfo.getProcDefKey(), (String)""));
            }
        }
    }
}

