/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.statistics.web.rest;

import cn.gtmap.gtc.workflow.domain.statistics.DepartmentalProcStatistics;
import cn.gtmap.gtc.workflow.domain.statistics.NormalProcStatistics;
import cn.gtmap.gtc.workflow.domain.statistics.PersonalProcStatistics;
import cn.gtmap.gtc.workflow.statistics.service.ProcStatisticsService;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/proc-statistics/v1"})
public class ProcStatisticController {
    @Autowired
    private ProcStatisticsService procStatisticsService;
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";

    @GetMapping(value={"/normal"})
    public List<NormalProcStatistics> getNormalStatisticsList(@RequestParam(value="startDate", required=false) String startDate, @RequestParam(value="endDate", required=false) String endDate) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put(START_DATE, startDate);
        params.put(END_DATE, endDate);
        return this.procStatisticsService.getNormalStatisticsList(params);
    }

    @GetMapping(value={"/users/{userId}"})
    public List<PersonalProcStatistics> getPersonalStatisticsList(@PathVariable(value="userId") String userId, @RequestParam(value="startDate", required=false) String startDate, @RequestParam(value="endDate", required=false) String endDate) {
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("userId", userId);
        params.put(START_DATE, startDate);
        params.put(END_DATE, endDate);
        return this.procStatisticsService.getPersonalStatisticsList(params);
    }

    @GetMapping(value={"/departments"})
    public List<DepartmentalProcStatistics> getDepartmentalStatisticsList(@RequestParam(value="departmentIds") String departmentIds, @RequestParam(value="startDate", required=false) String startDate, @RequestParam(value="endDate", required=false) String endDate) {
        if (StringUtils.isEmpty((String)departmentIds)) {
            return Collections.emptyList();
        }
        List<String> list = Arrays.asList(departmentIds.split(","));
        HashMap<String, Object> newParams = new HashMap<String, Object>(3);
        newParams.put(START_DATE, startDate);
        newParams.put(END_DATE, endDate);
        newParams.put("departmentIdList", list);
        return this.procStatisticsService.getDepartmentalStatisticsList(newParams);
    }
}

