/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.statistics.util;

import cn.gtmap.gtc.workflow.domain.statistics.BaseTaskStatisticsInfo;
import cn.gtmap.gtc.workflow.domain.statistics.OrgTaskStatisticsInfo;
import cn.gtmap.gtc.workflow.domain.statistics.UserTaskCountDto;
import cn.gtmap.gtc.workflow.domain.statistics.UserTaskStatisticsInfo;
import cn.gtmap.gtc.workflow.domain.statistics.UserTaskStatisticsTimeDto;
import cn.gtmap.gtc.workflow.enums.statistics.DateType;
import cn.gtmap.gtc.workflow.utils.GtmapDateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JsonResultBuilder {
    private static final Logger logger = LoggerFactory.getLogger(JsonResultBuilder.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private static final String AGGS_BY_CATEGORY_KEY = "byCategory";
    private static final String AGGS_BY_PROC_DEF_KEY = "byProcDefKey";
    private static final String AGGS_BY_TASK_NAME = "byTaskName";
    private static final String AGGS_PROC_INS_COUNT = "procInsCount";
    private static final String AGGS_STATISTICS_TIME = "grades_stats";
    private static final String COUNT = "count";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String AVG = "avg";
    private static final String SUM = "sum";

    public static List<OrgTaskStatisticsInfo> getStatisticsResultOfAllOrgs(String json) {
        if (StringUtils.isEmpty((Object)json)) {
            return Collections.emptyList();
        }
        JSONObject jsonObject = JSON.parseObject((String)json);
        JSONObject aggregations = jsonObject.getJSONObject("aggregations");
        if (aggregations == null) {
            return Collections.emptyList();
        }
        JSONObject byDept = aggregations.getJSONObject("byDept");
        JSONArray deptBuckets = byDept.getJSONArray("buckets");
        ArrayList<OrgTaskStatisticsInfo> list = new ArrayList<OrgTaskStatisticsInfo>();
        for (int i = 0; i < deptBuckets.size(); ++i) {
            JSONObject deptBucket = deptBuckets.getJSONObject(i);
            String deptId = deptBucket.getString("key");
            JSONObject byCategoryKey = deptBucket.getJSONObject(AGGS_BY_CATEGORY_KEY);
            JSONArray categoryKeyBuckets = byCategoryKey.getJSONArray("buckets");
            for (int c = 0; c < categoryKeyBuckets.size(); ++c) {
                JSONObject cateBucket = categoryKeyBuckets.getJSONObject(c);
                String category = cateBucket.getString("key");
                JSONObject byProcDefKey = cateBucket.getJSONObject(AGGS_BY_PROC_DEF_KEY);
                JSONArray procDefKeyBuckets = byProcDefKey.getJSONArray("buckets");
                for (int j = 0; j < procDefKeyBuckets.size(); ++j) {
                    JSONObject procDefKeyBucket = procDefKeyBuckets.getJSONObject(j);
                    String procDefKey = procDefKeyBucket.getString("key");
                    JSONObject byTaskName = procDefKeyBucket.getJSONObject(AGGS_BY_TASK_NAME);
                    JSONArray taskNameBuckets = byTaskName.getJSONArray("buckets");
                    for (int k = 0; k < taskNameBuckets.size(); ++k) {
                        JSONObject taskNameBucket = taskNameBuckets.getJSONObject(k);
                        OrgTaskStatisticsInfo info = new OrgTaskStatisticsInfo();
                        info.setOrgId(deptId);
                        info.setCategoryName(category);
                        info.setProcDefKey(procDefKey);
                        info.setTaskName(taskNameBucket.getString("key"));
                        info.setCount(taskNameBucket.getIntValue("doc_count"));
                        JSONObject procInsCount = taskNameBucket.getJSONObject(AGGS_PROC_INS_COUNT);
                        info.setRealCount(procInsCount.getIntValue("value"));
                        list.add(info);
                    }
                }
            }
        }
        return list;
    }

    public static List<UserTaskStatisticsInfo> getStatisticsResultByOrg(String json) {
        if (StringUtils.isEmpty((Object)json)) {
            return Collections.emptyList();
        }
        JSONObject jsonObject = JSON.parseObject((String)json);
        JSONObject aggregations = jsonObject.getJSONObject("aggregations");
        if (aggregations == null) {
            return Collections.emptyList();
        }
        JSONObject byUserId = aggregations.getJSONObject("byUserId");
        JSONArray userBuckets = byUserId.getJSONArray("buckets");
        ArrayList<UserTaskStatisticsInfo> list = new ArrayList<UserTaskStatisticsInfo>();
        for (int i = 0; i < userBuckets.size(); ++i) {
            JSONObject userBucket = userBuckets.getJSONObject(i);
            String userId = userBucket.getString("key");
            JSONObject byProcDefKey = userBucket.getJSONObject(AGGS_BY_PROC_DEF_KEY);
            JSONArray procDefKeyBuckets = byProcDefKey.getJSONArray("buckets");
            for (int j = 0; j < procDefKeyBuckets.size(); ++j) {
                JSONObject procDefKeyBucket = procDefKeyBuckets.getJSONObject(j);
                String procDefKey = procDefKeyBucket.getString("key");
                JSONObject byTaskName = procDefKeyBucket.getJSONObject(AGGS_BY_TASK_NAME);
                JSONArray taskNameBuckets = byTaskName.getJSONArray("buckets");
                for (int k = 0; k < taskNameBuckets.size(); ++k) {
                    JSONObject taskNameBucket = taskNameBuckets.getJSONObject(k);
                    UserTaskStatisticsInfo info = new UserTaskStatisticsInfo();
                    info.setUsername(userId);
                    info.setProcDefKey(procDefKey);
                    info.setTaskName(taskNameBucket.getString("key"));
                    info.setCount(taskNameBucket.getIntValue("doc_count"));
                    JSONObject procInsCount = taskNameBucket.getJSONObject(AGGS_PROC_INS_COUNT);
                    info.setRealCount(procInsCount.getIntValue("value"));
                    list.add(info);
                }
            }
        }
        return list;
    }

    public static List<UserTaskStatisticsTimeDto> getStatisticsTimeResult(String json) {
        if (StringUtils.isEmpty((Object)json)) {
            return Collections.emptyList();
        }
        JSONObject jsonObject = JSON.parseObject((String)json);
        JSONObject aggregations = jsonObject.getJSONObject("aggregations");
        if (aggregations == null) {
            return Collections.emptyList();
        }
        JSONObject byUserId = aggregations.getJSONObject("byUserId");
        JSONArray userBuckets = byUserId.getJSONArray("buckets");
        ArrayList<UserTaskStatisticsTimeDto> list = new ArrayList<UserTaskStatisticsTimeDto>();
        for (int i = 0; i < userBuckets.size(); ++i) {
            JSONObject userBucket = userBuckets.getJSONObject(i);
            String userId = userBucket.getString("key");
            JSONObject byProcDefKey = userBucket.getJSONObject(AGGS_BY_PROC_DEF_KEY);
            JSONArray procDefKeyBuckets = byProcDefKey.getJSONArray("buckets");
            for (int j = 0; j < procDefKeyBuckets.size(); ++j) {
                JSONObject procDefKeyBucket = procDefKeyBuckets.getJSONObject(j);
                String procDefKey = procDefKeyBucket.getString("key");
                JSONObject byTaskName = procDefKeyBucket.getJSONObject(AGGS_BY_TASK_NAME);
                JSONArray taskNameBuckets = byTaskName.getJSONArray("buckets");
                for (int k = 0; k < taskNameBuckets.size(); ++k) {
                    JSONObject taskNameBucket = taskNameBuckets.getJSONObject(k);
                    UserTaskStatisticsTimeDto info = new UserTaskStatisticsTimeDto();
                    info.setUsername(userId);
                    info.setProcDefKey(procDefKey);
                    info.setTaskName(taskNameBucket.getString("key"));
                    info.setCount(taskNameBucket.getIntValue("doc_count"));
                    JSONObject time = taskNameBucket.getJSONObject(AGGS_STATISTICS_TIME);
                    Integer realCount = time.getIntValue(COUNT);
                    info.setRealCount(realCount.intValue());
                    Double avg = time.getDouble(AVG);
                    if ((avg == null || avg == 0.0) && realCount > 0) {
                        avg = 1.0;
                    }
                    info.setAvg(avg);
                    Long max = time.getLongValue(MAX);
                    if ((max == null || max == 0L) && realCount > 0) {
                        max = 1L;
                    }
                    info.setMax(max);
                    info.setMin(Long.valueOf(time.getLongValue(MIN)));
                    Long sum = time.getLongValue(SUM);
                    if ((sum == null || sum == 0L) && realCount > 0) {
                        sum = (long)realCount;
                    }
                    info.setSum(sum);
                    list.add(info);
                }
            }
        }
        return list;
    }

    public static List<BaseTaskStatisticsInfo> getStatisticsResultByUser(String json) {
        if (StringUtils.isEmpty((Object)json)) {
            return Collections.emptyList();
        }
        JSONObject jsonObject = JSON.parseObject((String)json);
        JSONObject aggregations = jsonObject.getJSONObject("aggregations");
        if (aggregations == null) {
            return Collections.emptyList();
        }
        JSONObject byProcDefKey = aggregations.getJSONObject(AGGS_BY_PROC_DEF_KEY);
        JSONArray procDefKeyBuckets = byProcDefKey.getJSONArray("buckets");
        ArrayList<BaseTaskStatisticsInfo> list = new ArrayList<BaseTaskStatisticsInfo>();
        for (int i = 0; i < procDefKeyBuckets.size(); ++i) {
            JSONObject procDefKeyBucket = procDefKeyBuckets.getJSONObject(i);
            String procDefKey = procDefKeyBucket.getString("key");
            JSONObject byTaskName = procDefKeyBucket.getJSONObject(AGGS_BY_TASK_NAME);
            JSONArray taskNameBuckets = byTaskName.getJSONArray("buckets");
            for (int j = 0; j < taskNameBuckets.size(); ++j) {
                JSONObject taskNameBucket = taskNameBuckets.getJSONObject(j);
                BaseTaskStatisticsInfo info = new BaseTaskStatisticsInfo();
                info.setProcDefKey(procDefKey);
                info.setTaskName(taskNameBucket.getString("key"));
                info.setCount(taskNameBucket.getIntValue("doc_count"));
                JSONObject procInsCount = taskNameBucket.getJSONObject(AGGS_PROC_INS_COUNT);
                info.setRealCount(procInsCount.getIntValue("value"));
                list.add(info);
            }
        }
        return list;
    }

    public static List<UserTaskCountDto> buildUserTaskCount(String rs, DateType dateType) {
        if (StringUtils.isEmpty((Object)rs)) {
            return Collections.emptyList();
        }
        ArrayList dtos = Lists.newArrayList();
        JSONObject jsonObject = JSON.parseObject((String)rs);
        try {
            JSONObject aggs = jsonObject.getJSONObject("aggregations");
            JSONObject agglist = aggs.getJSONObject("list");
            JSONArray buckets = (JSONArray)agglist.get((Object)"buckets");
            for (int i = 0; i < buckets.size(); ++i) {
                JSONObject bucket = (JSONObject)buckets.get(i);
                UserTaskCountDto dto = new UserTaskCountDto();
                int count = Integer.parseInt(bucket.get((Object)"doc_count").toString());
                long time = Long.parseLong(bucket.get((Object)"key").toString());
                dto.setCount(count);
                dto.setDate(new Date(time));
                dto.setDateStr(GtmapDateUtils.dateToStr((Date)dto.getDate(), (String)dateType.getFormat()));
                dtos.add(dto);
            }
        }
        catch (Exception e) {
            logger.warn("buildUserTaskCount", (Throwable)e);
        }
        return dtos;
    }

    public static <T> T convertValue(Object o, Class<T> valueType) {
        return (T)mapper.convertValue(o, valueType);
    }
}

