/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.statistics.service.impl;

import cn.gtmap.gtc.workflow.entity.StatisticsTask;
import cn.gtmap.gtc.workflow.helper.AbstractWorkdayHelper;
import cn.gtmap.gtc.workflow.statistics.manager.StatisticsProcManager;
import cn.gtmap.gtc.workflow.statistics.manager.StatisticsTaskManager;
import cn.gtmap.gtc.workflow.statistics.service.MessageService;
import cn.gtmap.gtc.workflow.statistics.service.StatisticsProcWorkService;
import cn.gtmap.gtc.workflow.statistics.service.StatisticsTaskWorkService;
import cn.gtmap.gtc.workflow.statistics.service.impl.StatisticsBaseServiceImpl;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class StatisticsTaskWorkServiceImpl
extends StatisticsBaseServiceImpl
implements StatisticsTaskWorkService {
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private StatisticsTaskManager statisticsTaskManageService;
    @Autowired
    private StatisticsProcManager statisticsProcManageService;
    @Autowired
    private StatisticsProcWorkService statisticsProcWorkService;
    @Autowired
    private MessageService messageService;
    @Value(value="${statistics.time:claim}")
    private String statTime;

    public void addStatisticsTaskToEs(StatisticsTask statisticsTask) {
        SimpleDateFormat df = new SimpleDateFormat(this.statisticsTaskIndexSuffixFormat);
        String indexName = this.statisticsTaskIndexPrefix + "-" + df.format(statisticsTask.getTaskStartDate());
        try {
            String json = this.mapper.writeValueAsString((Object)statisticsTask);
            this.documentService.add(indexName, "doc", statisticsTask.getTaskId(), json);
        }
        catch (Exception e) {
            this.logger.error("\u4efb\u52a1\u7edf\u8ba1\u4fe1\u606f\u5b58\u50a8\u5230ES\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    public void updateStatisticsTaskToEs(StatisticsTask statisticsTask) {
        SimpleDateFormat df = new SimpleDateFormat(this.statisticsTaskIndexSuffixFormat);
        String indexName = this.statisticsTaskIndexPrefix + "-" + df.format(statisticsTask.getTaskStartDate());
        try {
            String json = this.mapper.writeValueAsString((Object)statisticsTask);
            this.documentService.update(indexName, "doc", statisticsTask.getTaskId(), json);
        }
        catch (Exception e) {
            this.logger.error("\u4efb\u52a1\u7edf\u8ba1\u4fe1\u606f\u5b58\u50a8\u5230ES\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    public void delStatisticsTaskFromEs(StatisticsTask statisticsTask) {
        if (statisticsTask != null) {
            SimpleDateFormat df = new SimpleDateFormat(this.statisticsTaskIndexSuffixFormat);
            String indexName = this.statisticsTaskIndexPrefix + "-" + df.format(statisticsTask.getTaskStartDate());
            try {
                this.documentService.delete(indexName, "doc", statisticsTask.getTaskId());
            }
            catch (Exception e) {
                this.logger.error("\u6d41\u7a0b\u7edf\u8ba1\u4fe1\u606f\u4eceES\u4e2d\u5220\u9664\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public boolean existsInEs(StatisticsTask statisticsTask) {
        SimpleDateFormat df = new SimpleDateFormat(this.statisticsTaskIndexSuffixFormat);
        String indexName = this.statisticsTaskIndexPrefix + "-" + df.format(statisticsTask.getTaskStartDate());
        try {
            String response = this.documentService.queryById(indexName, "doc", statisticsTask.getTaskId());
            return this.checkByJson(response);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u4efb\u52a1\u7edf\u8ba1\u4fe1\u606f\u5728ES\u4e2d\u662f\u5426\u5b58\u5728\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    private boolean checkByJson(String json) {
        JSONObject jsonObject = JSON.parseObject((String)json);
        return jsonObject.getBooleanValue("found");
    }

    public void changeOldData(StatisticsTask statisticsTask) {
        if (statisticsTask.getReckonTime() == null) {
            statisticsTask.setReckonTime(statisticsTask.getTaskStartDate());
            if (statisticsTask.getTaskDueDays() != null) {
                statisticsTask.setTaskTimeoutDays(Integer.valueOf(-statisticsTask.getTaskDueDays().intValue()));
            }
            if (statisticsTask.getTaskDueHours() != null) {
                statisticsTask.setTaskTimeoutHours(Integer.valueOf(-statisticsTask.getTaskDueHours().intValue()));
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void processStatisticsJob() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 4[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void initTaskStatisticsTime() {
        Integer pageNumber = 1;
        Integer pgeSize = 500;
        List statisticsTaskList = this.getStatisticsTaskPage(pageNumber, pgeSize);
        this.updateStatisticsTime(statisticsTaskList);
        this.delAndUpdateFromEs(statisticsTaskList);
        PageInfo pageInfo = new PageInfo(statisticsTaskList);
        int pages = pageInfo.getPages();
        for (int i = 2; i <= pages; ++i) {
            Integer n = pageNumber;
            Integer n2 = pageNumber = Integer.valueOf(pageNumber + 1);
            statisticsTaskList = this.getStatisticsTaskPage(pageNumber, pgeSize);
            this.updateStatisticsTime(statisticsTaskList);
            this.delAndUpdateFromEs(statisticsTaskList);
        }
    }

    private void delAndUpdateFromEs(List<StatisticsTask> statisticsTaskList) {
        if (CollectionUtils.isNotEmpty(statisticsTaskList)) {
            statisticsTaskList.stream().forEach(statisticsTask -> {
                this.delOldStatisticsTaskFromEs(statisticsTask);
                this.updateStatisticsTaskToEs(statisticsTask);
            });
        }
    }

    private void delOldStatisticsTaskFromEs(StatisticsTask statisticsTask) {
        if (statisticsTask != null) {
            SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD);
            String indexName = this.statisticsTaskIndexPrefix + "-" + df.format(statisticsTask.getTaskStartDate());
            try {
                this.documentService.delete(indexName, "doc", statisticsTask.getTaskId());
            }
            catch (Exception e) {
                this.logger.error("\u6d41\u7a0b\u7edf\u8ba1\u4fe1\u606f\u4eceES\u4e2d\u5220\u9664\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void updateStatisticsTime(List<StatisticsTask> statisticsTaskList) {
        if (CollectionUtils.isNotEmpty(statisticsTaskList)) {
            statisticsTaskList.stream().forEach(statisticsTask -> {
                List workDayList = this.getTaskWorkDays(statisticsTask, null, null);
                AbstractWorkdayHelper taskWorkdayHelper = this.getAbstractWorkdayHelper(workDayList);
                int statisticTime = this.getTaskTimeBetweenMins(statisticsTask.getTaskId(), statisticsTask.getTaskStartDate(), statisticsTask.getTaskEndDate(), taskWorkdayHelper);
                statisticsTask.setStatisticsTime(Long.valueOf((long)statisticTime + 0L));
                if (statisticsTask.getStatisticsTime() <= 0L) {
                    statisticsTask.setStatisticsTime(Long.valueOf(1L));
                }
                this.statisticsTaskManageService.updateStatisticsTask(statisticsTask);
            });
        }
    }

    private List<StatisticsTask> getStatisticsTaskPage(Integer pageNumber, Integer pgeSize) {
        PageHelper.startPage((int)pageNumber, (int)pgeSize);
        return this.statisticsTaskManageService.lisTaskStatisticsWithCompleteAndNoneStatisticTime();
    }
}

